C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c name: The program's name
c
      character  name*100

c
c curcon: Current connect number
c
      integer    curcon
c
c maxfile: Maximum number of input + output files
c
      integer    maxfile
c
c maxcomp: Maximum number of components
c
      integer    maxcomp

c
c maxtrlen: Maximum length of a MC trace, in bytes
c scrtrace: Scratch space for a trace this size.
c nulltrace: A null trace.
c
      integer    maxtrlen
      real       scrtrace
      pointer    (pscrtrace, scrtrace(2))
      real       nulltrace
      pointer    (pnulltrace, nulltrace(2))

c
c whichopen: which program opened this file...
c            uspinput (1) or uspoutput (2)
c            This array counts up by curclcon, not curcon
c
      integer    whichopen
      pointer    (pwhichopen, whichopen(2))

c
c nc: The number of components
c
      integer    nc
      pointer    (pnc, nc(2))

c
c n1, n2, n3, d1: specify geometry of dataset as it is on disk
c vn2, vn3: specify geometry of dataset as it is visible to the
c           user, after MC traces have been re-gathered together.
c wn2, wn3, wf2, wf3: specify windowed subset of dataset as it
c                     is visible to the user.
c trhlen: trace header length in reals
c trlen: trace length in reals, including trace header
c
      integer    n1, n2, n3
      integer    vn2, vn3
      integer    wn2, wn3, wf2, wf3
      real       d1
      integer    trhlen, trlen
      pointer    (pn1, n1(2))
      pointer    (pn2, n2(2))
      pointer    (pn3, n3(2))
      pointer    (pd1, d1(2))
      pointer    (pvn2, vn2(2))
      pointer    (pvn3, vn3(2))
      pointer    (pwn2, wn2(2))
      pointer    (pwn3, wn3(2))
      pointer    (pwf2, wf2(2))
      pointer    (pwf3, wf3(2))
      pointer    (ptrhlen, trhlen(2))
      pointer    (ptrlen, trlen(2))

c
c curclcon: How many sets of command-line options we have saved
c           (usually it will be the same as curcon, but it might be
c           greater if we have tried to open files, read the command
c           line, and then discovered a problem and un-opened the
c           file again)
c clns, clne, clrs, clre: specify command-line user windowing
c             parameters for this dataset
c clpass: pass-through set on command line
c clmctrsp: mctrsp set on command line
c
c         These all count up by curclcon, not curcon
c
      integer    curclcon
      integer    clns, clne, clrs, clre, clpass, clmctrsp
      pointer    (pclns, clns(2))
      pointer    (pclne, clne(2))
      pointer    (pclrs, clrs(2))
      pointer    (pclre, clre(2))
      pointer    (pclpass, clpass(2))
      pointer    (pclmctrsp, clmctrsp(2))


c 
c multiin: 2 means "Leon-style" one-file-per-component dataset
c          1 means one file contains all the components, but we
c            opened it several times to make it LOOK like several
c            files
c          0 means one file contains all the components, and we were
c            only able to open it once (scalar input falls under this
c            case)
c

#define MI_MULT		2
#define MI_MOPEN	1
#define MI_PIPE		0

      integer    multiin
      pointer    (pmultiin, multiin(2))

c
c lcomp: list of components
c
      integer    lcomp
      pointer     (plcomp, lcomp(2))

c
c luiomc: logical unit numbers
c
      integer    luiomc
      pointer     (pluiomc, luiomc(2))

c
c luorder: the order to read various components
c
      integer    luorder
      pointer     (pluorder, luorder(2))

c lunc: Number of components
c lun1: How many minor trace increments before a major trace increment
c lucn: Component number
c lucount: How many MC traces have been read/written so far from/to disk
c luucount: How many MC traces have been passed to/from the user
c lumax: How many traces actually exist in this file so far
c luumax: How many MC traces exist in this file so far
c luulim: How many MC traces should exist in this file at close time
c lustatus: How do we read this file?
c		-1: you don't
c		 0: Just go grab the traces in order
c		 1: Just go grab the traces
c                   (with perhaps some forward skips)
c		 2: Seek forwards and backwards
c		 3: Buffer in memory
c

#define IO_NOK		-1
#define IO_OK		0
#define IO_SKIP		1
#define IO_SEEK		2
#define IO_MEMBUF	3

      integer    lunc
      pointer    (plunc, lunc(2))
      integer    lun1
      pointer    (plun1, lun1(2))
      integer    lucn
      pointer    (plucn, lucn(2))
      integer    lucount
      pointer    (plucount, lucount(2))
      integer    luucount
      pointer    (pluucount, luucount(2))
      integer    lumax
      pointer    (plumax, lumax(2))
      integer    luumax
      pointer    (pluumax, luumax(2))
      integer    luulim
      pointer    (pluulim, luulim(2))
      integer    lustatus
      pointer    (plustatus, lustatus(2))

c
c luseek: Can we seek on this one?
c lubufsz: How big are the SISIO buffers?
c
      integer    luseek
      pointer    (pluseek, luseek(2))
      integer    lubufsz
      pointer    (plubufsz, lubufsz(2))

c
c canread: Can we read on this one?
c canwrite: Can we write on this one?
c
      integer    canread
      pointer    (pcanread, canread(2))
      integer    canwrite
      pointer    (pcanwrite, canwrite(2))
      integer    append
      pointer    (pappend, append(2))

c
c ipass: Do we pass windowed data on through unchanged?
c
      integer    ipass
      pointer    (pipass, ipass(2))
      integer    cinput
      pointer    (pcinput, cinput(2))

c
c inmctrsp: The input mctrsp for this file (will be used to pick a
c     default MC ordering for the corresponding output).
c
      integer     inmctrsp
      pointer     (pinmctrsp, inmctrsp(2))

c
c trace transpose buffer stuff
c
c trbstart: the trace number of the first trace in the buffer
c trbpoint: the next trace that would be read/written from/to the file
c        (lucount keeps track of where the next trace is as far as
c        the user program knows, which isn't the same thing if we
c        are using a trace transpose buffer)
c trbendpoint: the farthest trace on disk so far (lumax keeps track of
c        the farthest trace as far as the user program knows)
c trbchanged: how many traces have been modified in the current buffer
c
      integer     trbstart
      pointer     (ptrbstart, trbstart(2))
      integer     trbpoint
      pointer     (ptrbpoint, trbpoint(2))
      integer     trbendpoint
      pointer     (ptrbendpoint, trbendpoint(2))
      integer     trbchanged
      pointer     (ptrbchanged, trbchanged(2))


#define WINSTRLEN	20
c
c winstr: command-line windowing string
c         This string counts up by curclcon, not curcon
c
      character*WINSTRLEN   winstr
      pointer     (pwinstr, winstr(2))
c
c mcstr: command-line mctrsp string
c         This string counts up by curclcon, not curcon
c
      character*WINSTRLEN   mcstr
      pointer     (pmcstr, mcstr(2))


#define FINAMLEN	80
c
c file name (for error mesages and such)
c
      character*FINAMLEN    finame
      pointer     (pfiname, finame(2))

      save /UspInfoStruct/
      common /UspInfoStruct/
     1       name, curcon, maxfile, maxcomp,
     1       maxtrlen, pscrtrace, pnulltrace, pwhichopen,
     1       pnc, pn1, pn2, pn3, pd1,
     1       pvn2, pvn3, pwn2, pwn3, pwf2, pwf3,
     1       ptrhlen, ptrlen,
     1       curclcon, pclns, pclne, pclrs, pclre, pclpass, pclmctrsp,
     1       pmultiin, plcomp,
     1       pluiomc, pluorder,
     1       plunc, plun1, plucn,
     1       plucount, pluucount, plumax, pluumax, pluulim, plustatus,
     1       pluseek, plubufsz, pcanread, pcanwrite,
     1       pappend, pipass, pcinput, pinmctrsp,
     1       ptrbstart, ptrbpoint, ptrbendpoint, ptrbchanged,
     1       pwinstr, pmcstr, pfiname


#define  COMPSRC	1
#define  COMPREC	2

#define  SCALAR         -1

c
c Maximum number of components allowed (at least, this is all
c the ones we saved room for in the line header)
c
#define MCLLen		16

c
c How to pack (src,rec) components numbers into a single integer.
c Source times COMPBASE plus receiver.
c
#define COMPBASE	10

#define  LCOMP(WHICH,COMP,FILE)	lcomp(((WHICH)-1)+((COMP)-1)*2+((FILE)-1)*2*maxcomp+1)
#define  LUIOMC(COMP,FILE)	luiomc(((COMP)-1)+((FILE)-1)*maxcomp+1)
#define  LUORDER(COMP,FILE)	luorder(((COMP)-1)+((FILE)-1)*maxcomp+1)
#define  LUCN(COMP,FILE)	lucn(((COMP)-1)+((FILE)-1)*maxcomp+1)
#define  FINAME(COMP,FILE)	finame(((COMP)-1)+((FILE)-1)*maxcomp+1)

c The line header keyword MCTrSp defines how the multicomponent
c dimension is layed out in the MC input file:
c
c 0: Scalar (there is no MC dimension)
c 1: each MC super-trace occurs together, as NSrCmp * NRcCmp contiguous
c    traces; NumTrc is multiplied
c 2: standard ordering: each gather contiguous, followed by the
c    same gather again but the next component; NumRec is multiplied
c 3: entire line occurs contiguous, followed by the same line
c    again but with the next component; NumRec is multiplied

#define MC_SCALAR	0
#define MC_TRACE	1
#define MC_GATHER	2
#define MC_LINE		3

#define DPTW_IGNORE	-1
#define DPTW_WINDOW	0
#define DPTW_PASS	1

#define READ    0
#define WRITE   1
#define FLUSH   2
