C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*****************************************************************
c
c uspioinit.F
c
c USP
c High
c Level
c IO routines
c
c                                         Joe Dellinger
c                                         September-December 1994
c
c*****************************************************************



#define SCALAR		-1
#define COMPUNIT	3



      subroutine uspioinit (ourname, nfiles, ncomp)

c******************************************************************
c******************************************************************
c******************************************************************
c
c Allocate memory for all the things we'll need in the other
c high level IO routines.
c
c ourname: The program name
c nfiles:  The maximum number of input and output connections
c          that will be active.
c ncomp:   The maximum number of components in any one connection.
c
c******************************************************************
c******************************************************************
c******************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


#ifdef SUNSYSTEM
      implicit   none
#endif

      character  ourname*(*)
      integer    nfiles, ncomp

      integer    ierr, iabort
      integer    nblen
      integer    icon

      character  rname*(*)
      parameter (rname = 'uspioinit()')

#include "uspinfo.h"
      data curcon /-1/

#include "uspdeadtrace.h"


c******************************************************************
c
c Check for various bonehead errors
c
c******************************************************************


      if (nblen(ourname) .eq. 0) then
          name = 'UNKNOWN'
          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': No program name specified; using ''',
     1    name(1:nblen(name)), '''.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER , *) name(1:nblen(name)), ' ', rname,
     1    ': No program name specified; using ''',
     1    name(1:nblen(name)), '''.'
      else
          name = ourname
      endif


      if (curcon .ne. -1) then
       write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 ': ', rname, ' has already been called!'
#ifdef SUNSYSTEM
       call flush(LERR)
#endif
       write (LER , *) name(1:nblen(name)), ' ', rname,
     1 ': ', rname, ' has already been called!'
       write (LER , *) name(1:nblen(name)),
     1              ': FATAL'
       stop
      endif



      if (nfiles .le. 0 .or. ncomp .le. 0) then
       write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 ': ', nfiles, ' files, ', ncomp, ' components; nothing to open?'
#ifdef SUNSYSTEM
       call flush(LERR)
#endif
       write (LER , *) name(1:nblen(name)), ' ', rname,
     1 ': ', nfiles, ' files, ', ncomp, ' components; nothing to open?'
       write (LER , *) name(1:nblen(name)),
     1              ': FATAL'
       stop
      endif

      if (ncomp .gt. MCLLen) then
       write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 ': ', ncomp, ' components is too many. Max is ', MCLLen, '.'
#ifdef SUNSYSTEM
       call flush(LERR)
#endif
       write (LER , *) name(1:nblen(name)), ' ', rname,
     1 ': ', ncomp, ' components is too many. Max is ', MCLLen, '.'
       write (LER , *) name(1:nblen(name)),
     1              ': FATAL'
       stop
      endif

       write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 ': allocating space for'
       write (LERR, *) '          ', nfiles,
     1 ' files with up to ', ncomp, ' components each.'
#ifdef SUNSYSTEM
       call flush(LERR)
#endif


c*******************************************************************
c
c Allocate the space to store the parameters needed to describe
c multicomponent input and/or output files.
c
c*******************************************************************

      iabort = 1

      maxfile = nfiles
      maxcomp = ncomp

      call galloc (pwhichopen  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pnc  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pn1  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pn2  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pn3  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pd1  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pvn2  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pvn3  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pwn2  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pwn3  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pwf2  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pwf3  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrhlen  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrlen  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclns  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclne  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclrs  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclre  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclpass  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pclmctrsp  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pmultiin, maxfile * SZSMPD, ierr, iabort)
      call galloc (plcomp, maxfile * maxcomp * SZSMPD * 2, ierr, iabort)
      call galloc (pluiomc, maxfile * maxcomp * SZSMPD, ierr, iabort)
      call galloc (pluorder, maxfile * maxcomp * SZSMPD, ierr, iabort)
      call galloc (plunc  , maxfile * SZSMPD, ierr, iabort)
      call galloc (plun1  , maxfile * SZSMPD, ierr, iabort)
      call galloc (plucn  , maxfile * maxcomp * SZSMPD, ierr, iabort)
      call galloc (plucount  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pluucount  , maxfile * SZSMPD, ierr, iabort)
      call galloc (plumax  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pluumax  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pluulim  , maxfile * SZSMPD, ierr, iabort)
      call galloc (plustatus  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pluseek  , maxfile * SZSMPD, ierr, iabort)
      call galloc (plubufsz  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pcanread  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pcanwrite  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pappend  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pipass  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pcinput  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pinmctrsp  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrbstart  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrbpoint  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrbendpoint  , maxfile * SZSMPD, ierr, iabort)
      call galloc (ptrbchanged  , maxfile * SZSMPD, ierr, iabort)
      call galloc (pwinstr  , maxfile * WINSTRLEN, ierr, iabort)
      call galloc (pmcstr  , maxfile * WINSTRLEN, ierr, iabort)
      call galloc (pfiname  , maxfile * maxcomp * FINAMLEN,
     1             ierr, iabort)


      curcon = 0
      curclcon = 0
      maxtrlen = 0

      do icon = 1, maxfile

          call uspcleanslate (icon)

c
c If these are set then it means we read something off the command line.
c
          winstr(icon) = ' '
          mcstr(icon) = ' '
c
c    Neither uspinput or uspoutput opened this one yet
c
          whichopen(icon) = 0

      enddo

c
c    Initialize information needed for the 'uspdeadtrace' function call.
c

      call savelu('StaCor', ifmt_StaCor, l_StaCor,
     1                      ln_StaCor, TRACEHEADER)


      return
      end
