C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine uspmctrsp(mctrsp, numcmp, ierror)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c  Figure out how the components are arranged within the
c  input file.
c
c  MCTrSp is an integer between 0 and 3, inclusive.
c
c  0: Scalar: not a MC dataset, by itself at least; it could be a
c     single file in a Leon-style multi-file dataset.
c  1: "component axis Fast": all the parts of one MC trace occur
c     together as a contiguous unit; NumTrc (n2) is a multiple
c     of NumCmp (lunc).
c  2: "single-component gathers" (standard ordering): each gather
c     contiguous, followed by the same gather again but for the
c     next component; NumRec (n3) is a multiple of NumCmp (lunc).
c  3: "single-component lines": entire line occurs contiguous,
c     followed by the same line again but for the next component;
c     NumRec (n3) is a multiple of NumCmp (lunc).
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer    mctrsp, numcmp
      integer    ierror

      integer    nblen

      integer    icomp

      character  rname*(*)
      parameter (rname = 'uspmctrsp()')
 
#include "uspinfo.h"

c
c    If we're here, this input comes out of only one input file;
c    icomp doesn't matter, so just use 1 .
c
      icomp = 1

      if (numcmp .le. 1) then
c
c    The input file only has one component.
c
          write(LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Entirely one component in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    '''', '.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          lunc(curcon) = 1
          lun1(curcon) = 1

      else if (mctrsp .ge. MC_TRACE .and. mctrsp .le. MC_LINE) then
c
c    An MC input file
c
         if (mctrsp .eq. MC_TRACE) then
c
c    Component fast ordering
c
             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1       ': Component axis fast in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1       '''', '.'
#ifdef SUNSYSTEM
             call flush(LERR)
#endif

             lunc(curcon) = numcmp
             lun1(curcon) = 1

c    check n2 is a multiple of numcmp

             if (numcmp * int(n2(curcon)/numcmp) .ne.
     1                                n2(curcon)) then

                 write(LERR,*) name(1:nblen(name)), ' ', rname,
     1           ': NumTrc=', n2(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'
#ifdef SUNSYSTEM
                 call flush(LERR)
#endif
                 write(LER ,*) name(1:nblen(name)), ' ', rname,
     1           ': NumTrc=', n2(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'

                 ierror = ierror + 1
             endif

         else if (mctrsp .eq. MC_GATHER) then
c
c    Single-component gathers
c
             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1       ': Single-component gathers in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1       '''', '.'
#ifdef SUNSYSTEM
             call flush(LERR)
#endif

             lunc(curcon) = numcmp
             lun1(curcon) = n2(curcon)

c    check n3 is a multiple of numcmp
             if (numcmp * int(n3(curcon)/numcmp) .ne.
     1                                n3(curcon)) then


                 write(LERR,*) name(1:nblen(name)), ' ', rname,
     1           ': NumRec=', n3(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'
#ifdef SUNSYSTEM
                 call flush(LERR)
#endif
                 write(LER ,*) name(1:nblen(name)), ' ', rname,
     1           ': NumRec=', n3(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'

                 ierror = ierror + 1
             endif


         else if (mctrsp .eq. MC_LINE) then

c
c    Single-component "lines"
c
             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1       ': Single-component line segments in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1       '''', '.'
#ifdef SUNSYSTEM
             call flush(LERR)
#endif

             lunc(curcon) = numcmp
             lun1(curcon) = n2(curcon) * n3(curcon) / numcmp

c    check n3 is a multiple of numcmp
             if (numcmp * int(n3(curcon)/numcmp) .ne.
     1                                n3(curcon)) then

                 write(LERR,*) name(1:nblen(name)), ' ', rname,
     1           ': NumRec=', n3(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'
#ifdef SUNSYSTEM
                 call flush(LERR)
#endif
                 write(LER ,*) name(1:nblen(name)), ' ', rname,
     1           ': NumRec=', n3(curcon), ' not multiple of NumCmp=',
     1           numcmp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1           '''', '.'

                 ierror = ierror + 1
             endif

         endif

      else
         write(LERR,*) name(1:nblen(name)), ' ', rname,
     1   ': Invalid MCTrSp=', mctrsp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1   '''', '.'
#ifdef SUNSYSTEM
         call flush(LERR)
#endif
         write(LER ,*) name(1:nblen(name)), ' ', rname,
     1   ': Invalid MCTrSp=', mctrsp, ' in ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1   '''', '.'
         ierror = ierror + 1
      endif

      return
      end
