C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function usprtrace(icon, supertrace, tn1)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c usprtrace, uspwtrace
c
c Process reading (usprtrace) or writing (uspwtrace) a multicomponent
c trace. This routine does not actually read or write the trace; it
c calls usprwtrace to do that. This routine translates from user
c (windowed) dimensional coordinates to datafile (unwindowed)
c dimensional coordinates, checks that the requested trace is not out
c of bounds, and does "pass-through" processing as needed as well.
c
c icon is the connection number (returned from uspinput or uspoutput)
c
c supertrace is the datatrace to read the data into or out of,
c     with dimension supertrace(tn1,ncomp)
c
c tn1 is the fast dimension of supertrace (from the dimension statement)
c
c return value:
c     0: normal
c    -1: there was some sort of serious error (there will also be an
c        error message)
c     1: you've just incremented off the end of the data (no error
c        message, but if you persist in going off the end of the data
c        the next time the status will be -1 and there will be!)
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icon
      integer tn1
      real supertrace(tn1,*)
      integer usprtrace, uspwtrace, usprwtrace, usppass

      integer ntrace
      integer i2, i3, lcount
      integer nblen

      integer row

#include "uspinfo.h"

      character*(11)  rname(2)
      data rname(READ+1), rname(WRITE+1)
     1   / 'usprtrace()', 'uspwtrace()' /



      row = READ
      goto 100

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Separate function entry for WRITING.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

      entry uspwtrace(icon, supertrace, tn1)

      row = WRITE

c
c Merge the two streams back together
c

 100  continue



      if (icon .le. 0 .or. icon .gt. curcon) then
          write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Connection ', icon, ' not opened.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Connection ', icon, ' not opened.'

          usprtrace = -1
          return
      endif

      if (lustatus(icon) .eq. IO_NOK) then
c
c Oops! Something's wrong!
c
          write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'

          usprtrace = -1
          return
      endif


c
c Find out where we're supposed to be!
c

      ntrace = luucount(icon) + 1


      if (append(icon) .eq. 0 .and.
     1       ntrace .eq. luulim(icon) + 1) then
c
c If they attempt to increment once off the end, just return a "1"
c to let them know they're done (since they obviously aren't counting
c for themselves).
c
#ifdef DEBUG
          if (row .eq. READ) then
              write (LERR,*) 'In ', rname(row+1), ' Reading Trace ',
     1            ntrace
          else
              write (LERR,*) 'In ', rname(row+1), ' Writing Trace ',
     1            ntrace
          endif
          write (LERR,*) '      One increment off the end.'
#endif

          luucount(icon) = luucount(icon) + 1
          usprtrace = 1
          return
      endif


#ifdef DEBUG
      if (row .eq. READ) then
          write (LERR,*) 'In ', rname(row+1), ' Reading Trace ', ntrace
      else
          write (LERR,*) 'In ', rname(row+1), ' Writing Trace ', ntrace
      endif
#endif

      if ((row .eq. READ .and. ntrace .gt. luumax(icon)) .or.
     1           (row .eq. WRITE .and. append(icon) .eq. 0 .and.
     1            ntrace .gt. luulim(icon))) then

c
c Other than that, going off the end is an error!
c
          if (row .eq. READ) then
              write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to read off the end of input ', icon, '.'
          else
              write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to write off the end of output ', icon, '.'
          endif
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          if (row .eq. READ) then
              write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to read off the end of input ', icon, '.'
          else
              write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to write off the end of output ', icon, '.'
          endif

          usprtrace = -1
          return
      endif

      if (ntrace .lt. 1) then
          if (row .eq. READ) then
              write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to read before the beginning of input ',
     1        icon, '.'
          else
              write (LERR,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to write before the beginning of output ',
     1        icon, '.'
          endif
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          if (row .eq. READ) then
              write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to read before the beginning of input ',
     1        icon, '.'
          else
              write (LER ,*) name(1:nblen(name)), ' ', rname(row+1),
     1        ': Attempt to write before the beginning of output ',
     1        icon, '.'
          endif

          usprtrace = -1
          return
      endif



c
c    Handle windowing:
c         Figure out where we want to be as far as usprwtrace is
c         concerned, and put it in lcount
c
      if (wn2(icon) .ne. vn2(icon) .or.
     1                           wn3(icon) .ne. vn3(icon)) then

          i3 = int((ntrace-1) / wn2(icon)) + 1
          i2 = (ntrace-1) - (i3-1) * wn2(icon) + 1
          i3 = i3 + wf3(icon) - 1
          i2 = i2 + wf2(icon) - 1
          lcount = (i3 - 1) * vn2(icon) + i2

c
c    Handle pass-through. If we're reading a trace that's after a
c    windowed gap, then pass along all the skipped-over traces.
c   
          if (row .eq. READ .and. ipass(icon) .ne. 0 .and.
     1                   lcount .gt. lucount(icon) + 1) then

              usprtrace = usppass(icon, lcount)

              if (usprtrace .ne. 0) then
                  return
              endif

          endif

      else
c
c    No windowing: no translation necessary!
c
          lcount = ntrace

      endif


      usprtrace = usprwtrace(icon, row, supertrace, tn1, lcount)

      luucount(icon) = ntrace

c
c    If we wrote off the end without error, then we must have made
c    the file bigger.
c
      if (ntrace .gt. luumax(icon) .and. row .eq. WRITE .and.
     1                          usprtrace .eq. 0) then
          luumax(icon) = ntrace
      endif


#ifdef DEBUG
      write (LERR,*)
#endif

      return
      end
