C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      function uspseek(icon, traceno)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Seek on connection icon to trace traceno.
c
c icon is the input or output number (returned from uspinput or
c uspoutput).
c
c traceno is the trace number to seek to. (Note: no real seeking occurs
c until you actually try to read or write something!) If traceno is
c negative or zero, then seek that many traces back from the current
c end of the file, and write the resulting trace number into traceno.
c (If traceno is 0, writing will begin just after what's there now.)
c
c return value:
c     0: normal
c    -1: you aren't allowed to seek on this file
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif


      integer icon, traceno, uspseek

      integer nblen

      character  rname*(*)
      parameter (rname = 'uspseek()')
 
#include "uspinfo.h"



      if (icon .le. 0 .or. icon .gt. curcon) then
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon, ' not opened.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon, ' not opened.'

          uspseek = -1
          return
      endif

      if (lustatus(icon) .eq. IO_NOK) then
c
c Oops! Something's wrong!
c
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'
 
          uspseek = -1
          return
      endif

c
c    Negative or zero traceno's count back from the current EOF
c
      if (traceno .le. 0) then
          traceno = luumax(icon) + 1 - traceno
      endif


      if (luucount(icon) .ne. traceno - 1 .and.
     1                                 ipass(icon) .ne. 0) then
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Cannot seek on passed-through connection ', icon, '.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1    ': Cannot seek on passed-through connection ', icon, '.'

          uspseek = -1
          return
      endif


      luucount(icon) = traceno - 1

      uspseek = 0
      return

      end
