C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ACCT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ACCT                                                            *
C      GAMOVR  (IARR,NLIN,NPR,JDATVR)                                  *
C      HLH  (IHDR,LEN,HARR,NBYTES)                                     *
C      HLHLU  (NPR)                                                    *
C      NACCT  (KODE,IHEAD,ICHG)                                        *
C      NACCT2  (IRECP)                                                 *
C      CCEXIT  (IRET)                                                  *
C      LINKLD  (JDATVR)                                                *
C  ARGUMENTS:                                                          *
C      IARR    INTEGER    ??IOU*      -                                *
C      NLIN    INTEGER    ??IOU*      -                                *
C      NPR     INTEGER    input       - logical unit for hlh print     *
C      JDATVR  INTEGER    ??IOU*      -                                *
C      IHDR    INTEGER    input       - line header                    *
C      LEN     INTEGER    update      - length of line header in bytes *
C      HARR    CHAR       input  (*)  - addition to hlh                *
C      NBYTES  INTEGER    input       - length in bytes of harr        *
C      KODE    INTEGER    ??IOU*      -                                *
C      IHEAD   INTEGER    ??IOU*      -                                *
C      ICHG    INTEGER    ??IOU*      -                                *
C      IRECP   INTEGER    ??IOU*      -                                *
C      IRET    INTEGER    input       - error code                     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   dave kight                         ORIGIN DATE: 90/04/17  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      HLHPRT -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  this thing was originally set up on the Cray  *
C  by Dave Kight as a bunch of dummy entry points and a little bit of  *
C  actual code to simulate some general purpose SIS routines. As actual*
C  functionality now exists for some of the original subroutine, the   *
C  dummy entry points have been removed. Hopefully this thing will     *
C  eventually go away completely.                                      *
C  REVISED BY:  (rewritten) joe m. wade       REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C  FILES:            NONE                                              *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE ACCT
#include <f77/iounit.h>
      character HARR(*)
      integer hlhlun
      save hlhlun
      data hlhlun / 6 /
C.
      ENTRY GAMOVR(IARR,NLIN,NPR,JDATVR)
C.
C.         THIS ENTRY POINT SIMULATES A CALL TO THE SIS SUBROUTINE
C.         'GAMOVR'.  NO PROCESSING OR I/O IS ACTUALLY PERFORMED.
C.
         RETURN
C.
      ENTRY HLH(IHDR,LEN,HARR,NBYTES)
C.
c	hlhprt duplicates the actions of hlh except that
c	the logical unit is passed in explicitly
C.
         call hlhprt(ihdr,len,harr,nbytes,hlhlun)
         RETURN
C.
      ENTRY HLHLU(NPR)
C.
c	this entry sets the logical unit used for printing the hlh
c
         hlhlun = npr
         RETURN
C.
      ENTRY NACCT(KODE,IHEAD,ICHG)
C.
C.         THIS ENTRY POINT SIMULATES A CALL TO THE SIS SUBROUTINE
C.         'NACCT'.  NO PROCESSING OR I/O IS ACTUALLY PERFORMED.
C.
         RETURN
C.
      ENTRY NACCT2(IRECP)
C.
C.         THIS ENTRY POINT SIMULATES A CALL TO THE SIS SUBROUTINE
C.         'NACCT2'.  NO PROCESSING OR I/O IS ACTUALLY PERFORMED.
C.
         RETURN
C.
      ENTRY CCEXIT(IRET)
C.
C.         THIS ENTRY POINT SIMULATES A CALL TO THE SIS SUBROUTINE
C.         'CCEXIT'.  IF THE REURN CODE (IRET) IS ZERO A STOP IS
C.         EXECUTED, OTHERWISE A CALL IS MADE TO THE SUBROUTINE ABEND.
C.
c	- modified to write to stderr - j.m.wade - 7/15/93
c
         IF(IRET .ne. 0)
     1     write(LER,*) ' PROGRAM TERMINATED: ERROR CODE - ',IRET
c        CALL ABEND(IRET)
c        STOP
         stop
C.
      ENTRY LINKLD(JDATVR)
C.
C.         THIS ENTRY POINT SIMULATES A CALL TO THE SIS SUBROUTINE
C.         'LINKLD'.  NO PROCESSING OR I/O IS ACTUALLY PERFORMED.
C.
         RETURN
C.
      END
