C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DOT                                                  *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DOT  (L,X,Y,P)                                                  *
C  ARGUMENTS:                                                          *
C      L       INTEGER  ??IOU*      -                                  *
C      X       REAL     ??IOU*  (1) -                                  *
C      Y       REAL     ??IOU*  (1) -                                  *
C      P       REAL     ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE DOT(L,X,Y,P)
      DIMENSION X(1),Y(1)                                               DOT40010
C
C     DOT IS THE DOT PRODUCT OF TWO VECTORS
C     REFERENCE: EAR MULTICHANNEL VOLUME, P. 20.
C                                                                       DOT70040
C     INPUTS ARE                                                        DOT70070
C        L=LENGTH OF THE VECTORS X AND Y                                DOT70080
C        X=THE VECTOR X, X(1),X(2),...,X(L)                             DOT70090
C        Y=THE VECTOR Y Y(1),Y(2),...,Y(L)                              DOT70100
C     OUTPUTS ARE                                                       DOT70110
C        P=DOT PRODUCT OF X AND Y
C
C                L                                                      DOT70160
C COMPUTES    P= SUM(X(I)*Y(I))   IF  L  GRTHN 0                        DOT70170
C                I=1                                                    DOT70180
C                                                                       DOT70190
C             P= 0                IF  L  EQLSTHN 0                      DOT70200
C                                                                       DOT70210
      P=0.0                                                             DOT70220
      IF (L)3,3,1                                                       DOT70230
    1 DO 2 I=1,L                                                        DOT70240
    2 P=P+X(I)*Y(I)                                                     DOT70250
    3 RETURN                                                            DOT70260
      END                                                               DOT70270
