C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FILTER                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FILTER  (X,II,FI)                                               *
C  ARGUMENTS:                                                          *
C      X       REAL*4   ??IOU*  (2048) -                               *
C      II      INTEGER  ??IOU*         -                               *
C      FI      REAL*4   ??IOU*  (8)    -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE FILTER(X,Ii,FI)
C
C     FILTER VERSION 1 *************************************************
C
      REAL*4    X(2048),FI(8),C(3),D(3),E(3)
      data c/3*0.0/,d/3*0.0/,e/3*0.0/
C     MOD3(INDEX)=INDEX-((INDEX-1)/3)*3
      XIM2=X(1)
      XIM1=X(2)
      XI=X(3)
      IF(ABS(XIM2) .LT. 1.E-30) XIM2=0.
      IF(ABS(XIM1) .LT. 1.E-30) XIM1=0.
      IF(ABS(XI) .LT. 1.E-30) XI=0.
      C(1)=XIM2
      C(2)=XIM1-FI(1)*C(1)
      C(3)=XI-XIM2-FI(1)*C(2)-FI(2)*C(1)
      D(1)=C(1)
      D(2)=C(2)-FI(3)*D(1)
      D(3)=C(3)-C(1)-FI(3)*D(2)-FI(4)*D(1)
      E(1)=D(1)
      E(2)=D(2)-FI(5)*E(1)
      E(3)=D(3)-D(1)-FI(5)*E(2)-FI(6)*E(1)
      X(1)=E(1)
      X(2)=E(2)-FI(7)*X(1)
      X(3)=E(3)-E(1)-FI(7)*X(2)-FI(8)*X(1)
      DO 1 I=4,Ii
      XIM2=XIM1
      XIM1=XI
      XI=X(I)
      IL=I - ((I-1)/3)*3
      IM1L=I-1 - ((I-2)/3)*3
      IM2L=I-2 - ((I-3)/3)*3
      C(IL)=XI-XIM2-FI(1)*C(IM1L)-FI(2)*C(IM2L)
      D(IL)=C(IL)-C(IM2L)-FI(3)*D(IM1L)-FI(4)*D(IM2L)
      E(IL)=D(IL)-D(IM2L)-FI(5)*E(IM1L)-FI(6)*E(IM2L)
      X(I)=E(IL)-E(IM2L)-FI(7)*X(I-1)-FI(8)*X(I-2)
C     IWRT=0
C     DO 2 K=1,3
C     IF(C(K).EQ.0.0)IWRT=1
C     IF(D(K).EQ.0.0)IWRT=1
C     IF(E(K).EQ.0.0)IWRT=1
C   2 CONTINUE
C     IF(IWRT.EQ.1)WRITE(6,201)I,C,D,E
    1 CONTINUE
C 201 FORMAT(' I=',I6,5(1X,E12.6))
      RETURN
      END
