C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FITF                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FITF  (XIN,YIN,STDD,NSAMP,COF,N,ARRAY,NFIT,COVM,NCOVM,CHI,XMIN, *
C             XMAX,ITYPE)                                              *
C  ARGUMENTS:                                                          *
C      XIN      REAL     ??IOU*  (NSAMP)                               *
C      YIN      REAL     ??IOU*  (NSAMP)                               *
C      STDD     REAL     ??IOU*  (NSAMP)                               *
C      NSAMP   INTEGER  ??IOU*                                         *
C      COF       REAL     ??IOU*  (MMAX)                               *
C      NA      INTEGER  ??IOU*                                         *
C      ARRAY   INTEGER  ??IOU*  (MMAX)                                 *
C      NFIT    INTEGER  ??IOU*                                         *
C      COVM   REAL     ??IOU*  (NCOVM,NCOVM)                           *
C      NCOVM    INTEGER  ??IOU*                                        *
C      CHI   REAL     ??IOU*                                           *
C      XMIN    REAL     ??IOU*                                         *
C      XMAX    REAL     ??IOU*                                         *
C      ITYPE   INTEGER  ??IOU*                                         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FUNCS  -                                                        *
C      GAUSSJ -                                                        *
C      COVSRT -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine fitf (xin, yin, STDD, nsamp, COF, na, array, nfit,
     1                 covm, ncovm, chi, xmin, xmax, itype, nmax)
 
#include <f77/iounit.h>
 
c  give nsamp data points X(i), Y(i) with std devs STDD(i) use chi**2 min
c  to determine NFIT of  NA coefficients COF of a function that de[ends linearly
c  on [ y = sum{ COF[i] * UFUNC[i](x) } ]
c  array  ARRAY renumbers the parameters so that the first NFIT elements
c  correspond to the parameters actually being determined; the remaining
c  NA - NFIT elements are held fixed at their input values.
c  fitf
c  returns values for the NA fit parameters COF, the chi**2, and the covariance
C  matrix COVM(ncovm, ncovm) - ncovm is the dimension of COVM in the calling
c  prgm.
c  user supplies a subroutine FUNCS(X, UFUNC, N, ...) that returns the N basis
c  functions evaluated at X(1:N) in the array UFUNC
c  the user function: call funcs (xi, ufunc, na, xmin, xmax, itype)
c  where itype is the type of function, e.g. polynomial or exponential, and
c  where xmin,xmax define dependent variable limits for calculating other
c  types of functions [see ~usp/src/cmd/fitter for examples]
 
c  xmin & xmax are the min & max limits of xin
c  itype = type of function
 
      real      xin(nsamp), yin(nsamp), STDD(nsamp), COF(nmax)
      integer   array(nmax), itype
      real      covm(ncovm,ncovm)
      real      bas, ufunc
      pointer   (wkbas, bas(1))
      pointer   (wkufunc, ufunc(1))
      real      xmin, xmax
      integer   jsz, nmax, ierr, ierrt, iabort
      iabort = 0

      call sizefloat(jsz)
      ierrt = 0
      call galloc (wkbas, nmax*jsz, ierr, iabort)
      ierrt = ierrt + ierr
      call galloc (wkufunc, nmax*jsz, ierr, iabort)
      ierrt = ierrt + ierr
      if (ierrt .ne. 0) then
         write(LERR,*)'Memory allocation failure in fits -- FATAL'
         write(LER ,*)'Memory allocation failure in fits -- FATAL'
         call ccexit(666)
      endif
 
      ll = nfit + 1
 
      do  j = 1, na
          ih = 0
          do  k = 1, nfit
              if (array(k) .eq. j) ih = ih + 1
          enddo
 
          if (ih .eq. 0) then
             array(ll) = j
             ll = ll + 1
          elseif(ih .gt. 1) then
             write(LERR,*)'subroutine fits: wrong set in ARRAY'
             return
          endif
 
      enddo
 
          if (ll-1 .ne. na) then
             write(LERR,*)'subroutine fitf: wrong set in ARRAY'
             return
          endif
 
          do  j = 1, nfit
 
              do  k =  1, nfit
                  covm(j,k) = 0.
              enddo
 
              bas(j) = 0.
 
          enddo
 
          do  i  =  1, nsamp
 
              yi = yin(i)
              xi = xin(i)
              call funcs (xi, ufunc, na, xmin, xmax, itype)
              if (nfit .lt. na) then
                 do  j = nfit+1, na
                     yi = yi - COF(array(j)) * ufunc(array(j))
                 enddo
              endif
 
              stddsqi = 1./stdd(i) **2
 
              do  j  = 1, nfit
                  wt =  ufunc(array(j)) * stddsqi
                  do  k = 1, j
                      covm(j,k) = covm(j,k) + wt * ufunc(array(k))
                  enddo
 
                  bas(J) = bas(j) + yi*wt
              enddo
          enddo
 
          if (nfit .gt. 1) then
             do  j = 2, nfit
                 do  k = 1, j-1
                     covm(k,j) = covm(j,k)
                 enddo
             enddo
          endif
 
          call axeqb (covm, nfit, bas, 1)
 
          do  j = 1, nfit
              COF(array(j)) = bas(j)
          enddo
 
          chi = 0.
 
          do  i = 1, nsamp
              xi = xin(i)
              call funcs(xi, ufunc, na, xmin, xmax, itype)
              sum = 0.
              do  j =  1, na
                  sum = sum + COF(j) * ufunc(j)
              enddo
              chi = chi + ((yin(i) - sum)/STDD(i)) **2
              yin(i) = sum
          enddo
 
          call pakcov (covm, ncovm, na, array, nfit)
 
      call gfree (wkbas)
      call gfree (wkufunc)
 
      return
      end
 
 
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PAKCOV                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PAKCOV  (COVM,NCOVM,MA,ARRAY,NFIT)                              *
C  ARGUMENTS:                                                          *
C      COVM   REAL     ??IOU*  (NCOVM,NCOVM) -                          *
C      NCOVM    INTEGER  ??IOU*              -                          *
C      NA      INTEGER  ??IOU*              -                          *
C      ARRAY   INTEGER  ??IOU*  (*)         -                          *
C      NFIT    INTEGER  ??IOU*              -                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine  pakcov (covm, ncovm, na, array, nfit)
 
c   given a covariance matrix COVM of a fit for NFIT of NA parameters, and
c   their ordering ARRAY(i), repack the covariance matrix to the true order
c   of the parameters.
c   Elements associated with fixed parameters will be 0
 
      dimension covm(ncovm, ncovm), array(*)
 
      do  12  j = 1, na-1
          do  11  i = j+1, na
              covm(i,j) = 0.
11        continue
12    continue
 
      do  14  i = 1, nfit-1
          do  13  j = i+1, nfit
              if (array(j) .gt. array(i)) then
                 covm(array(j), array(i)) = covm(i,j)
              else
                 covm(array(i), array(j)) = covm(i,j)
              endif
13        continue
14    continue
 
      tmp = covm(1,1)
 
      do  15  j = 1, na
          covm(1,j) = covm(j,j)
          covm(j,j) = 0.
15    continue
 
      covm(array(1), array(1)) = tmp
 
      do  16  j = 2, nfit
          covm(array(j), array(j)) = covm(1,j)
16    continue
 
      do  18  j = 2, na
          do  17  i = 1, j-1
              covm(i,j) = covm(j,i)
17        continue
18    continue
 
      return
      end
 

C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       AXEQB                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      AXEQB  (A,N,B,M)                                         *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (NP,NP) -                              *
C      N       INTEGER  ??IOU*          -                              *
C      B       REAL     ??IOU*  (NP,MP) -                              *
C      M       INTEGER  ??IOU*          -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine axeqb (a, n, b, m)
 
#include <f77/iounit.h>
 
c   solve linear equation by gauss-jordan elimination of the equation
 
c                    AX = B
 
c   A is NxN input matrix
c   B is an input matrix NxM.
c   on output A is replaced by by its matrix inverse and B is replaced
c   by the matrix of solution vectors X
 
      dimension A(n,n), B(n,m)
      integer jsz, ierr, ierrt, iabort
      integer pivot, rowind, colind
      pointer (wkpivot , pivot(1))
      pointer (wkrowind, rowind(1))
      pointer (wkcolind, colind(1))
      iabort = 0
      ierrt  = 0

      call sizefloat(jsz)
      nmax = max (n, m)
      
      call galloc (wkpivot , nmax*jsz, ierr, iabort)
      ierrt = ierrt + ierr
      call galloc (wkrowind, nmax*jsz, ierr, iabort)
      ierrt = ierrt + ierr
      call galloc (wkcolind, nmax*jsz, ierr, iabort)
      ierrt = ierrt + ierr
      if (ierrt .ne. 0) then
         write(LERR,*)'Memory allocation error in axeqb -- FATAL'
         write(LER ,*)'Memory allocation error in axeqb -- FATAL'
         call ccexit(666)
      endif
 
      do  j = 1, n
          pivot(j) = 0
      enddo
 
      DO  i = 1, n
          fact = 0.
          do  j = 1, n
              if (pivot(j) .ne. 1) then
                 do  k = 1, n
                     if (pivot(k) .eq. 0) then
                        if (abs(A(j,k)) .ge. fact) then
                           fact = abs(A(j,k))
                           irow = j
                           icol = k
                        endif
                     elseif( pivot(k) .gt. 1) then
                       write(LERR,*)'axeqb: singular matrix'
                       return
                     endif
                 enddo
              endif
          enddo
 
          pivot(icol) = pivot(icol) + 1
 
          if (irow .ne. icol) then
             do  L = 1, n
                 tmp = A(irow, L)
                 A(irow, L) = A(icol, L)
                 A(icol, L) = tmp
             enddo
 
             do  L = 1, m
                 tmp = B(irow, L)
                 B(irow, L) = B(icol, L)
                 B(icol, L) = tmp
             enddo
          endif
 
          rowind(i) = irow
          colind(i) = icol
          if (A(icol,icol) .eq. 0.) then
             write(LERR,*)'axeqb: singular matrix'
             return
          endif
 
          pivoti = 1./A(icol,icol)
          A(icol,icol) = 1.
 
          do  L = 1, n
              A(icol, L) = A(icol, L) * pivoti
          enddo
 
          do  L = 1, m
              B(icol, L) = B(icol, L) * pivoti
          enddo
 
          do  LL = 1, n
              if (LL .ne. icol) then
                 tmp = A(LL,icol)
                 A(LL,icol) = 0.
                 do  L = 1, n
                     A(LL,L) = A(LL,L) - A(icol,L) * tmp
                 enddo
 
                 do  L = 1, m
                     B(LL,L) = B(LL,L) - B(icol,L) * tmp
                 enddo
 
              endif
          enddo
 
      ENDDO
 
      do  L = n, 1, -1
          if (rowind(L) .ne. colind(L)) then
             do  k = 1, n
                 tmp = A(k,rowind(L))
                 A(k,rowind(L)) = A(k,colind(L))
                 A(k,colind(L)) = tmp
             enddo
          endif
      enddo

      call gfree (wkpivot)
      call gfree (wkrowind)
      call gfree (wkcolind)
 
      return
      end
 
