C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FOUR                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FOUR  (DATA,NN,ISIGN,DT,DF)                                     *
C  ARGUMENTS:                                                          *
C      DATA    REAL*4   ??IOU*  (*) -                                  *
C      NN      INTEGER  ??IOU*      -                                  *
C      ISIGN   INTEGER  ??IOU*      -                                  *
C      DT      REAL     ??IOU*      -                                  *
C      DF      REAL     ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIN     GENERIC -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine four(data,nn,isign,dt,df)
c-----
c     the cooley-tookey fast fourier transform in usasi basic fortran
c     transform(j) = sum(data(i)*w**((i-1)(j-1)), where i and j run
c     from 1 to nn and w = exp(isign*2*pi*sqrt(-1)/nn).  data is a one-
c     dimensional complex array (i.e., the real and imaginary parts of
c     data are located immediately adjacent in storage, such as fortran
c     places them) whose length nn is a power of two.  isign
c     is +1 or -1, giving the sign of the transform.  transform values
c     are returned in array data, replacing the input data.  the time is
c     proportional to n*log2(n), rather than the usual n**2
c     rms resolution error being bounded by 6*sqrt(i)*log2(nn)*2**(-b),
c     b is the number of bits in the floating point fraction.
c
c     the program computes df from dt, dt from df and checks to see
c     if they are consistent. In addition, the transforms are multiplied
c     by dt or df to make the results dimensionally correct
c-----
      real*4 data(*)
		n = 2 * nn
		if(dt.eq.0.0) dt = 1./(nn*df)
		if(df.eq.0.0) df = 1./(nn*dt)
		if(dt.ne.(nn*df)) df = 1./(nn*dt)
		j = 1
		do 5 i=1,n,2
			if(i.lt.j)then
				tempr = data(j)
				tempi = data(j+1)
				data(j) = data(i)
				data(j+1)=data(i+1)
				data(i) = tempr
				data(i+1) = tempi
			endif
			m = n/2
    3			if(j.le.m) goto 4
				j = j-m
				m = m/2
				if(m.ge.2)goto 3
    4			continue
			j=j+m
    5		continue
		mmax = 2
    6		if(mmax.ge.n) goto 10
			istep= 2 *mmax
			theta = 6.283185307/float(isign*mmax)
			sinth=sin(theta/2.)
			wstpr=-2.*sinth*sinth
			wstpi=sin(theta)
			wr=1.0
			wi=0.0
			do 9 m=1,mmax,2
					do 8 i=m,n,istep
					j=i+mmax
					tempr=wr*data(j)-wi*data(j+1)
					tempi=wr*data(j+1)+wi*data(j)
					data(j)=data(i)-tempr
					data(j+1)=data(i+1)-tempi
					data(i)=data(i)+tempr
					data(i+1) = data(i+1)+tempi
    8					continue
					tempr = wr
					wr = wr*wstpr-wi*wstpi + wr
					wi = wi*wstpr+tempr*wstpi + wi
    9			continue
			mmax = istep
		go to 6
   10		continue
		if(isign.gt.0)then
c-----
c	frequency to time domain
c-----
			do 1001 iiii = 1,n
				data(iiii) = data(iiii) * df
 1001			continue
		else
c-----
c	time to frequency domain
c-----
			do 1003 iiii = 1,n
				data(iiii) = data(iiii) * dt
 1003			continue
		endif
	return
	end
 
