C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GAIN                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GAIN  (FREQLC,FREQHC,UNIT,II,FI,G)                              *
C  ARGUMENTS:                                                          *
C      FREQLC  REAL     ??IOU*      -                                  *
C      FREQHC  REAL     ??IOU*      -                                  *
C      UNIT    REAL     ??IOU*      -                                  *
C      II      INTEGER  ??IOU*      -                                  *
C      FI      REAL     ??IOU*  (8) -                                  *
C      G       REAL     ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FILTER -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIN     GENERIC -                                               *
C      ABS     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE GAIN(FREQLC,FREQHC,UNIT,II,FI,G)
      DIMENSION X(4000),FI(8)
      W=SQRT(FREQLC*FREQHC)*6.2831853
      T=0.0
      DO 1 I=1,II
      X(I)=SIN(W*T)
      T=T+1.0/UNIT
    1 CONTINUE
      CALL FILTER(X,II,FI)
      G=0.0
      ISTART=II/2
      DO 2 I=ISTART,II
      T=ABS(X(I))
      IF(G.LT.T)G=T
    2 CONTINUE
      RETURN
      END
