/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>

char zero_len = '\0';

/* this is a  little function that I had to write to
*      use the X Toolkit wrappers that I had already
*      implemented on the Sun.  It simply returns a
*      NULL terminated string in it's own space.
*	RICK COOK          7-28-88
*/
/*     Modified the code to include blanks in the string.
       Previous code was blank or null terminated. The 
       Sun passed the string with blanks, so I assumed
       he wanted to do the same thing here.
        Joe M. Wade        9-20-88

       Put in the check to see if the malloc of space  
       failed. If it did, return a null string. We could 
       kill the program here, but we would probably leave
       some garbage on the screen.
        Joe M. Wade        5-01-89
    
       Modified this subroutine to include a functionality
       on the Sun. Primary difference is that length of 
       character string comes in as a separate argument
       whereas it is part of character pointer on the Cray
        Joe M. Wade        5-17-89  				*/


#ifndef CRAYSYSTEM
char *get_c_string(f_string, len)
  char *f_string;
  unsigned len;
#else
#ifdef CRAYSYSTEM
#include <fortran.h>

char *get_c_string(string)
  _fcd string;
#endif
#endif
    {
#ifdef CRAYSYSTEM
    char *f_string = _fcdtocp(string);
    unsigned len = _fcdlen(string);
#endif
    char *c_string;
 
    if (len == 0)
        {
        return(&zero_len);
        }

    c_string = (char *) malloc( (len*sizeof(char)) + 1 );

    if (c_string == 0)
      {
      fprintf(stderr,
       " malloc of space in get_c_string failed: len = %d characters\n",
       len+1);
      return(&zero_len);
      }

    strncpy(c_string, f_string, len);

    c_string[len] = (char) NULL;
    return(c_string);
    }

