C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GTTAPR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GTTAPR  (WEIGHT,F1,F2,F3,F4,DF,KFMIN,KFMAX)                     *
C  ARGUMENTS:                                                          *
C      WEIGHT  REAL     ??IOU*  (KFMIN:KFMAX) -                        *
C      F1      REAL     ??IOU*                -                        *
C      F2      REAL     ??IOU*                -                        *
C      F3      REAL     ??IOU*                -                        *
C      F4      REAL     ??IOU*                -                        *
C      DF      REAL     ??IOU*                -                        *
C      KFMIN   INTEGER  ??IOU*                -                        *
C      KFMAX   INTEGER  ??IOU*                -                        *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MIN     GENERIC -                                               *
C      NINT    INTEGER -                                               *
C      MAX     GENERIC -                                               *
C      COS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine gttapr(weight,f1,f2,f3,f4,df,kfmin,kfmax)
      real      weight(kfmin:kfmax)
C_______________________________________________________________________
c     apply a tukey tapered bandpass filter between f1,f2,f3,f4.
C_______________________________________________________________________
      kf1=nint(f1/df)
      kf2=nint(f2/df)
      kf3=nint(f3/df)
      kf4=nint(f4/df)
c
      do 200 k=kfmin,min(kf1,kfmax)
       weight(k)=0.
200   continue
c
      taper=f2-f1
      if(taper .eq. 0.) then
         if( kf1 .ge. kfmin .and. kf1 .le. kfmax) then
             weight(kf1)=1.
         endif
      else
         factuk=3.141592/taper
         do 250 k=max(kf1,kfmin),min(kf2,kfmax)
          freq=k*df
          arg=(f2-freq)*factuk
          weight(k)=.5*(1.+cos(arg))
250      continue
      endif
C
      do 300 k=max(kf2+1,kfmin),min(kf3-1,kfmax)
       weight(k)=1.
300   continue
C
      taper=f4-f3
      if(taper .eq. 0.) then
         if( kf3 .ge. kfmin .and. kf3 .le. kfmax) then
            weight(kf3)=1.
         endif
      else
         factuk=3.141592/taper
         do 350 K=max(kf3,kfmin),min(kf4,kfmax)
           freq=k*df
           arg=(freq-f3)*factuk
           weight(k)=.5*(1.+cos(arg))
350      continue
      endif
C
      do 400 k=max(kf4+1,kfmin),kfmax
       weight(k)=0.
400   continue
C
      return
      end
