c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
#include <f77/localsys.h>
c-----
c	This is the basic code to control the historical
c	line header. This will handle either the SUN/IBM format
c	or the CSOS format. The Cray is messy because the string
c	counts occur on 8 byte integer boundaries, whereas the
c	SUN/IBM has the two byte integer interspersed irrespective
c	of word boundary
c-----
c       Changed the code so that lines over 1000 characters are truncated.
c						- joe m. wade 3/18/96
c-----
	subroutine savhlh(itr,lbytes,lbyout)
	integer*2 itr(*)
	integer*4 lbytes, lbyout
#include <f77/iounit.h>
#include <f77/sisdef.h>
	integer iargcc
	integer lnstr
        external sargvv
        character*256 sargvv
	character tbuf*256
	character outbuf*1000
c-----
c	extract all arguments from command line
c	including program name
c	put into array outbuf
c-----
		nmarg = iargcc()
		k = 1
		outbuf = ' '
		do 100 i=0,nmarg-1
			if(i.gt.0)then
				if (k .le. 1000) then
				  outbuf(k:k)=' '
				  k = k + 1
				endif
			endif
			tbuf = sargvv(i)
			l2 = lnstr(tbuf)
			l1=0
c
c - modified to strip full path off of arg 0 - joe m. wade - 11/23/96
c
			if (i .eq. 0) then
		          do 10 m=l1+1,l2
			    if (tbuf(m:m) .eq. '/') l1=m
   10      		  continue
			endif
c
			if (k+l2-l1 .le. 1000) then
			  outbuf(k:k+l2-l1)=tbuf(l1+1:l2)
			  k = k + l2 - l1
			else
			  outbuf(k:1000) = '....'
			  k = 1001
			endif
  100		continue
		k = k - 1
c-----
c	If on the CRAY, ensure that k is a multiple of 8 bytes
c-----
	if(CSOS.eq.1)then
		if(mod(k,HLHINT).ne.0)then
			mwords = k/HLHINT
			k = (mwords+1)*HLHINT
		endif
	endif
c-----
c	update the line header
c-----
		call stfhlh(itr,lbytes,lbyout,outbuf,k)
	return
	end
 
	subroutine stfhlh(itr,lbytes,lbyout,outbuf,k)
	integer*2 itr(*)
	integer*4 lbytes,lbyout
	character outbuf*(*)
	integer k
#include <f77/sisdef.h>
	integer ipos
	integer*4 nentry, nbytes
	character sval*8
		call saver(itr,'HlhEnt',nentry,LINHED)
		call saver(itr,'HlhByt',nbytes,LINHED)
		ipos = 1
c-----
c	convert the number of characters
c	to a HLHINT byte character
c-----
		call savws(sval,k,ipos)
c-----
c	add these HLHOUT bytes to the end of the line header
c-----
		call fstcpy(itr,HLHOFF+nbytes+1,sval,1,HLHINT,1)
		nbytes = nbytes + HLHINT
c-----
c	now tack on the string
c-----
		call fstcpy(itr,HLHOFF+nbytes+1,outbuf,1,k,1)
		nbytes = nbytes + k
c-----
c	update the number of entries in the line header
c-----
		nentry = nentry + 1
		call savew(itr,'HlhEnt',nentry,LINHED)
c-----
c	update the byte count in hlh
c-----
		call savew(itr,'HlhByt',nbytes,LINHED)
c-----
c	update the number of bytes in the line header
c-----
		lbyout = lbytes + HLHINT + k
	return
	end
		
 
	integer function lnstr(str)
	character str*(*)
		lstr = len(str)
		do 100 i= lstr,1,-1
			lnstr = i
			if(str(i:i).ne.' ')return
  100		continue
		lnstr = 0
	return
	end
 
      subroutine shwhlh(itr)
	integer*2 itr(*)
#include <f77/iounit.h>
#include <f77/sisdef.h>
        character out*4000
	integer  cpos, ipos, ebytes
	integer*4 nentry,nbytes
	character sval*8
		call saver(itr,'HlhEnt',nentry,LINHED)
		call saver(itr,'HlhByt',nbytes,LINHED)
		write(LOT,*)" "
		write(LOT,*)"HLH Entries",nentry," HLH bytes",nbytes
c-----
c	loop over entries
c-----
		cpos = HLHOFF + 2*HLHINT
		do 100 i=1,nentry
			cpos = cpos + HLHINT
			call fstcpy(itr,cpos-HLHINT+1,sval,1,HLHINT,0)
			ipos = 1
			call savrs(sval,ebytes,ipos)
			if(ebytes.gt.0)then
				call fstcpy(itr,cpos+1,out,1,ebytes,0)
			endif
			call out80(out,ebytes)
			if(CSOS.eq.1)then
				if(mod(ebytes,HLHINT).ne.0)then
					mwords = ebytes/HLHINT
					ebytes = (mwords+1)*HLHINT
				endif
			endif
			cpos = cpos + ebytes
  100		continue
	return
	end
 
	subroutine out80(str,n)
c-----
c	output the string in nice 80 column chunks
c-----
#include <f77/iounit.h>
	character str*(*)
	integer n
	integer ks,ke
		ks = 1
		ke = 80
 1000		continue
			if(ks.gt.n)return
			if(ke.gt.n)ke = n
			write(LOT,'(a)')str(ks:ke)
			ks = ks + 80
			ke = ke + 80
		go to 1000
	end
 
	subroutine savws(itr,val,pos)
	integer*2 itr(1)
	integer*4 val, pos
		itr(pos) = val
	return
	end
 
	subroutine savrs(itr,val,pos)
	integer*2 itr(1)
	integer*4 val, pos
		val = itr(pos)
	return
	end
 
	subroutine fstcpy(iarr,i1,str,s1,count,toitr)
	integer*2 iarr(*)
	integer i1
	character str*(*)
	integer s1,count
	integer toitr
c-----
c	Fortran string copy routine
c	The object is to get around the problems of passing character
c	strings through command line arguments in Fortran, especially
c	when the array is a mixed integer-float-character structure
c	We must get down to byte addressing without the overhead
c	of passing the number of characters along with the string
c
c	Even though iarr is an integer array, we wish to consider it
c	a string, such that if we could do an
c
c	equivalence (iarr(1),arr(1:1))
c	character arr*(*)
c
c	in a subroutine, we would like to have
c
c	toitr != 0
c		arr(i1+1:i1+count) = str(s1+1:s1+count)
c	toitr  = 0
c		str(s1+1:s1+count) = arr(i1+1:i1+count)
c
c-----
	integer*4 inttoc
	integer*4 ival
	do 1000 i=0,count-1
		if(toitr .ne. 0)then
			ival = ichar(str(s1+i:s1+i))
			call ctoint(iarr,ival,i1+i)
		else
			ival = inttoc(iarr,i1+i)
			str(s1+i:s1+i)=char(ival)
		endif
 1000	continue
	return
	end
