C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       OPENPR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  OPEN FILES FOR PRINTOUTS                                  *
C  ENTRY POINTS:                                                       *
C      OPENPR  (LPARNT,LPRNT,PNAME,JERR)                               *
C  ARGUMENTS:                                                          *
C      LPARNT  INTEGER    I    -  LU FOR PARENT PRINTOUT               *
C      LPRNT   INTEGER    I    -  LU FOR INDIVIDUAL PROGRAM PRINTOUT   *
C      PNAME   CHAR*(*)   I    -  PROGRAM IDENTIFIER (NAME)            *
C      JERR    INTEGER    U    -  ERROR FLAG FOR OPENING FILES         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/12/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GETPPS         - RETURNS PARENT PROCESS ID AND PROCESS ID       *
C      INTSTR  CHAR*6 -                                                *
C      IKPCHK         -                                                *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      LEN     INTEGER -                                               *
C  FILES:                                                              *
C      LER     ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THE FIRST TIME THIS SUBROUTINE IS CALLED WITH-*
C       - IN A JOB FLOW, A FILE WILL BE CREATED CALLED ID.PPID AND ONE *
C       - CALLED ID.PPID.PRT AND A FILE TO CONTAIN THE PRINTOUT FROM AN*
C       - INDIVIDUAL PROGRAM.  THE ID.PPID FILE WILL BE UPDATED ON EACH*
C       - SUCCEEDING CALL TO THIS ROUTINE WITHIN ONE JOB FLOW TO CONTAI*
C       - THE NAME OF THE INDIVIDUAL PROGRAM PRINTOUT, SO WHEN THE JOB *
C       - IS COMPLETELY FINISHED, 'TERM' CAN COLLATE ALL THE PRINTOUTS *
C       - AND ADD JOB ACCOUNTING INFORMATION AND PRINT THE FINAL PRINT-*
C       - OUT AND REMOVE THE INTERMEDIATE PRINTOUTS FROM THE SYSTEM.   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/12/09  *
C            -  CHECK FOR MORE THAN 1 ZERO IN PID'S AND ADD ERROR FLAG *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/01/25  *
C            -  REMOVE WRITE STATEMENTS & INTSTR ROUTINE AT END        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/02/10  *
C            -  CHECK FOR MORE THAN 1 ZERO IN PID'S (PRIOR FIX FAILED) *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/02/10  *
C            -  TRY CLOSING PARNT HERE TO AVOID DUPLICATION ON FINALP.O*
C  REVISED BY:  JOE M. WADE                   REVISION DATE: 92/01/08  *
C            -  TAKE OUT THE USE OF THE PARENT PID IN THE INDIVIDUAL   *
C               PROGRAM PRINTOUT FILE BEING OPENED. THIS ENABLES US    *
C               TO USE A MORE DESCRIPTIVE (UP TO 7 CHARS) NAME ENTRY.  *
C               PID LENGTH IS INCREASED TO 6 DIGITS SINCE THAT IS THE  *
C               MAXIMUM WE'VE ENCOUNTERED SO FAR (CRAY). HOWEVER,      *
C               PADDING WITH ZEROES HAS BEEN ELIMINATED; ONLY SIGNIF-  *
C               ICANT DIGITS ARE USED. FORCE ERROR MESSAGES TO STDERR, *
C               RATHER THAN STDOUT.                                    *
C  REVISED BY:  JOE M. WADE                   REVISION DATE: 92/02/01  *
C            -  Due to new behaviour on the part of the UNICOS system  *
C               on the cray with respect to end of file, I installed   *
C               a line to BACKSPACE the temporary file which is        *
C               created to "cat" together all of the intermediate      *
C               printout files after we've gotten an end-of-file on    *
C               reading it before writing the new additions.           *
C  REVISED BY:  JOE M. WADE                   REVISION DATE: 93/06/30  *
C               I've modified the code to eliminate the parent print-  *
C               out files because of fatal collisions when processes   *
C               in a piped flow try to create or write data to these   *
C               files at the same time. Sometime in the future we may  *
C               try to reinstate this option via a clospr routine or   *
C               some such, but not right now. I am saving the old code *
C               which had the parent printouts into the file           *
C               openpr.F.93181 in ~usp/src/lib/ut on the 1. As a     * *
C               quick explanation of the reasoning, the method put     *
C               forth for collating the individual printouts failed    *
C               miserably for piped jobs, where all the processes are  *
C               running concurrently.                                  *
C  REVISED BY:  JOE M. WADE                   REVISION DATE: 93/06/30  *
C               I'm also adding a bit of logic to suffix the individ-  *
C               ual printout file by the name of the machine if the    *
C               environmental variable IKP_PID has been set. This will *
C               prevent collisions across parallel machines running    *
C               out of the same directory when the pids coincide. ( it *
C               sounds far-fetched, but it happens!! )                 *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/09/24 ==================   *
C      INTSTR  CHAR*5 - CONVERTS CHAR.STRING TO INTEGER                *
C      INDEX   INTEGER -                                               *
C      LPRNT   ( OUTPUT SEQUENTIAL ) -                                 *
C  =============================== DATE: 93/06/24 ==================   *
C      7       ( OUTPUT SEQUENTIAL ) -                                 *
C      LPARNT  ( UPDATE SEQUENTIAL ) -                                 *
C  =============================== DATE: 96/02/08 ==================   *
C      ACCTID         -                                                *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE OPENPR(LPARNT,LPRNT,PNAME,JERR)
 
      CHARACTER*(*) PNAME
      CHARACTER*6 PID6,INTSTR
      CHARACTER*24 PRNT
      character*9 host
      INTEGER PID,PPID
      INTEGER PIDCH
 
#include <f77/iounit.h>
 
      data pid6 /'      '/
 
C     GETPPS RETURNS PROCESS-ID AND PARENT-PROCESS-ID
C     OPEN INDIVIDUAL PGM PRINTOUT W/PNAME   (FILE=PRNT,UNIT=LPRNT)
C     STAMP TEMP PARENT PRINTOUT WITH THE PROGRAM PRINTOUT NAME
C     FOR CORRELATION WITH OTHER PARENT PROCESS PROGRAMS LATER
C
      JERR=0
      CALL GETPPS(PID,PPID)
      PID6  = INTSTR(PID)
c
      PIDCH = 1
      DO 20 K=1,LEN(PID6)
         IF(PID6(K:K) .EQ. ' ') PIDCH=K+1
   20 CONTINUE
C
c	This should never happen, but I wanted to be sure - jmw
C
      IF ( PIDCH .GT. LEN(PID6)) THEN
         write(LER,*) '   ERROR DECODING PIDS FOR PROGRAM PRINTOUT'
	 JERR = 1
         RETURN
      ENDIF
C
c     I added this to truncate long names and eliminate blanks
c
c     Mofified 8/8/96 to eliminate use of ":" characters in printout name
c     - it's confusing and it screws up rmprint. - zjmw36
c
      NAMLEN = LEN(PNAME)
      if (namlen .gt. 7) namlen = 7
      do 5 i=namlen,1,-1
	if ((pname(i:i) .eq. ' ') .or.
     *	   (pname(i:i) .eq. ':' )) namlen = i - 1
    5 continue
C
	call IKPCHK(HOST)
        if (host .eq. '         ') then
	  PRNT  = PNAME(1:NAMLEN)//'.'//PID6(PIDCH:LEN(PID6))
	else
	  PRNT  = PNAME(1:NAMLEN)//'.'//PID6(PIDCH:LEN(PID6))//'.'//HOST
	endif
 
C     OPEN THE INDIVIDUAL PROGRAM PRINTOUT
      OPEN(UNIT=LPRNT,FILE=PRNT,STATUS='NEW',IOSTAT=JERR)
      IF ( JERR .NE. 0 ) THEN
         write(LER,*) '   OPEN ERROR = ', JERR ,
     1        ' ON PROGRAM PRINTOUT'
         RETURN
      ENDIF
C
      RETURN
      END
