/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
	This trivial little subroutine was developed by moi to 
	count up the number of pipes in an array of descriptors
	which are hooked to something other that /dev/null. Its
	primary use is for programs which are started by ikp
	(an iconic processor ), where the user grounds all pipes
	which he doesn't use. 
						- joe m. wade 9/10/90
*/

#include <stdio.h>
#include <localsys.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ut_defs.h>

int F_PIPCNT(pipes,pipe_max)
int pipes[];
int *pipe_max;
{
  int i,k,unit;
  int real_pipe_max = *pipe_max;
  int pipe_count = 0;
  unsigned long null_inode;
  struct stat buf;

/* get the inode number for /dev/null for comparison purposes */

  if ( stat("/dev/null",&buf) != 0 ) 
    {
    fprintf(stderr,"pipcnt: unable to determine inode number of /dev/null\n");
    exit(1);
    }
  else
    {
    null_inode = buf.st_ino;
    }
    
#ifdef DEBUG
  fprintf(stderr,"pipcnt: real_pipe_max = %d\n",real_pipe_max);
#endif

  for (i = 0, unit=pipes[0]; i<real_pipe_max; i++, unit=pipes[i])
    {
#ifdef DEBUG
  fprintf(stderr,"        unit = %d\n",unit);
#endif
    if ( fstat(unit,&buf) == 0)
      {
      if (buf.st_ino != null_inode ) {

/*  ---- since the vendors can't get their shit together, I count 'em all  */

#ifdef DEBUG
  fprintf(stderr,"count this as a pipe\n");
#endif
	pipe_count++;
	}
      else {
#ifdef DEBUG
  fprintf(stderr,"unit %d is connected to /dev/null\n",unit);
#endif
        (void) close(unit);
	real_pipe_max--;
        for (k = i; k<real_pipe_max; k++) 
	  pipes[k] = pipes[k+1];
	i--;
	}
      }
    else
      {
        fprintf(stderr,"pipcnt: error encountered checking status of ");
	fprintf(stderr,"unit %d, continuing\n",unit);
	real_pipe_max--;
        for (k = i; k<real_pipe_max; k++) 
	  pipes[k] = pipes[k+1];
	i--;
      }
    }
    
  return pipe_count;
}
