C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SMOOTH                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SMOOTH  (LS,SPECT)                                              *
C  ARGUMENTS:                                                          *
C      LS      INTEGER  ??IOU*      -                                  *
C      SPECT   REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine smooth (ls, spect)
c
c  subroutine to do spectral periodogram smoothing by the
c  Hamming-Tukey method (see Robinson Multispectral book, p91)
c
c  input:
c         ls  -  length of input spectrum
c       spect -  input unsmoothed spectrum
c
c  output:
c       spect -  output smoothed spectrum
c
      real    spect(*)
      integer ls
 
      mm = ls-1
      a = .54*spect(1) + .46*spect(2)
      b = .54*spect(ls) + .46*spect(mm)
      sj = spect(1)
      sk = spect(2)
 
      do  10  j = 2, mm
 
              si = sj
              sj = sk
              sk = spect(j+1)
              spect(j) = .54*sj + .23*(si + sk)
 
10    continue
 
      spect(1) = a
      spect(ls) = b
 
      return
      end
