C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       WRCARD                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      WRCARD  (KARD,FLAG,IPR)                                         *
C      WRCRD                                                           *
C      CRDPT                                                           *
C  ARGUMENTS:                                                          *
C      KARD    CHAR*1   ??IOU*  (80) -                                 *
C      FLAG    INTEGER  ??IOU*       -                                 *
C      IPR     INTEGER  ??IOU*       -                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPR  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE WRCARD (KARD,FLAG,IPR)
C
C
C*********************************************************************
C
C       SUBROUTINE WRCARD                ENTRY POINT - WRCARD
C
C       LANGUAGE - FORTRAN
C
C       AUTHOR - PHILLIP MANNING
C
C       DATE WRITTEN - 08/13/81
C
C       MODIFICATION HISTORY - 09/11/81  PI(PTM)
C
C       AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN
C                                          CONFIDENCE
C
C       ABSTRACT -
C
C         THIS SUBROUTINE IS USED FOR WRITING OUT THE INPUT
C         CARD SO THAT THE USER CAN VERIFY THE INPUT TO THE
C         PROGRAM.
C
C         THIS SUBROUTINE USES A FLAG TO INDICATE WHICH LINES
C         SHOULD BE WRITTEN ON THE OUTPUT.
C
C
C       PERTINENT INFORMATION -
C
C         PARAMETERS -
C
C                KARD - A LOGICAL*1 ARRAY CONTAINING THE INPUT CARD
C
C                FLAG - INDICATES WHICH LINES SHOULD BE WRITTEN TO
C                       THE OUTPUT FILE
C
C                IPR  - THIS IS THE LOGICAL UNIT FOR THE OUTPUT FILE
C
C         INTERNAL VARIABLE -
C
C                I1   - THE NUMBER OF THE INPUT CARD
C
C*********************************************************************
C
C          FLAG CAN ASSUME THE FOLLOWING VALUES WITH THE
C          INDICATED MEANINGS:
C
C        VALUE              MEANING
C        -----              -------
C          1            WRITE THE PRIMARY HEADER,
C                             THE COLUMN LINE,
C                             THE CARD NUMBER AND CARD IMAGE
C
C          2            WRITE THE PRIMARY HEADER AND
C                             THE COLUMN LINE
C
C          3            WRITE THE CARD NUMBER AND CARD IMAGE
C
C          4            WRITE THE COLUMN LINE
C
C          5            WRITE THE BYPASS HEADER,
C                             THE COLUMN LINE,
C                             THE CARD NUMBER AND CARD IMAGE
C
C          6            WRITE THE BYPASS HEADER AND
C                             THE COLUMN LINE
C
C*********************************************************************
C
C
      INTEGER I1,FLAG,IPR
cx    LOGICAL*1 KARD(80)
      character*1 kard(80)
      DATA I1/0/
C
C
C-----------------------------------------------------------C
C     THIS IS THE PRIMARY HEADING FOR THE OUTPUT REPORT.    C
C     FLAG MUST BE EQUAL TO 1 IN ORDER TO GET THE HEADING   C
C     PRINTED OUT.                                          C
C-----------------------------------------------------------C
C
C
      IF (FLAG.NE.1) GO TO 2
C
      I1 = I1+1
      WRITE (IPR,1) I1,KARD
      GO TO 14
C
C
    1 FORMAT (///53X,'***** CARD INPUT *****'////16X,'CARD',5X,
     $'         1         2         3         4','         5         6
     $       7         8'/17X,'NO',6X,'----+----0----+----0----+----0---
     $-+----0','----+----0----+----0----+----0----+----0'/13X,I6,6X,80A1
     $)
C
C
C-----------------------------------------------------------C
C     THIS IS THE PRIMARY HEADING FOR THE OUTPUT REPORT.    C
C     FLAG MUST BE EQUAL TO 2 IN ORDER TO GET ONLY THE      C
C     PAGE AND COLUMN HEADINGS.                             C
C-----------------------------------------------------------C
C
C
    2 IF (FLAG.NE.2) GO TO 4
C
      WRITE (IPR,3)
      GO TO 14
C
C
    3 FORMAT (///53X,'***** CARD INPUT *****'////16X,'CARD',5X,
     $'         1         2         3         4','         5         6
     $       7         8'/17X,'NO',6X,'----+----0----+----0----+----0---
     $-+----0','----+----0----+----0----+----0----+----0')
C
C
C-----------------------------------------------------------C
C    THIS WRITES OUT THE CARD NUMBER AND THE CARD IMAGE     C
C    OF THE INPUT TO THE PROGRAM.  FLAG MUST BE 3 IN        C
C    IN ORDER TO GET ONLY THE CARD NUMBER AND CARD IMAGE    C
C    PRINTED OUT.                                           C
C-----------------------------------------------------------C
    4 IF (FLAG.NE.3) GO TO 6
C
      I1 = I1+1
      WRITE (IPR,5) I1,KARD
      GO TO 14
C
C
    5 FORMAT (13X,I6,6X,80A1)
C
C
C-----------------------------------------------------------C
C     THIS IS THE STANDARD COLUMN HEADING LINE TO BE USED   C
C     ON THE OUTPUT REPORT TO INDICATE THE POSITIONS ON     C
C     THE CARD.  FLAG MUST BE 4 IN ORDER TO GET ONLY THE    C
C     COLUMN HEADING PRINTED OUT.                           C
C-----------------------------------------------------------C
C
C
    6 IF (FLAG.NE.4) GO TO 8
C
      WRITE (IPR,7)
      GO TO 14
C
C
    7 FORMAT (//25X,'----+----1----+----2----+----3----+----4',
     $'----+----5----+----6----+----7----+----8')
C
C
C-----------------------------------------------------------C
C     THIS IS THE SECONDARY PAGE HEADING FOR THE OUTPUT     C
C     REPORT.  THIS HEADING IS USED WHEN THE CARD THAT      C
C     WAS INPUT TO THE PROGRAM IS TO BE BYPASSED.  FLAG     C
C     MUST BE EQUAL TO 5 IN ORDER TO PRINT THIS HEADING.    C
C-----------------------------------------------------------C
C
C
    8 IF (FLAG.NE.5) GO TO 10
C
      I1 = I1+1
      WRITE (IPR,9) I1,KARD
      GO TO 14
C
C
    9 FORMAT (///47X,'***** CARD INPUT (BYPASSED) *****'////16X,'CARD'
     $,5X,'         1         2         3         4','         5
     $ 6         7         8'/17X,'NO',6X,'----+----0----+----0----+----
     $0----+----0','----+----0----+----0----+----0----+----0'/13X,I6,6X,
     $80A1)
C
C
C-----------------------------------------------------------C
C     THIS IS THE SECONDARY PAGE HEADING FOR THE OUTPUT     C
C     REPORT.  THIS HEADING IS USED WHEN THE CARD THAT      C
C     WAS INPUT TO THE PROGRAM IS TO BE BYPASSED.  FLAG     C
C     MUST BE EQUAL TO 6 IN ORDER TO PRINT ONLY THE         C
C     SECONDARY PAGE HEADING AND THE COLUMNS HEADING.       C
C-----------------------------------------------------------C
C
C
   10 IF (FLAG.NE.6) GO TO 12
C
      WRITE (IPR,11)
      GO TO 14
C
C
   11 FORMAT (///47X,'***** CARD INPUT (BYPASSED) *****'////16X,'CARD'
     $,5X,'         1         2         3         4','         5
     $ 6         7         8'/17X,'NO',6X,'----+----0----+----0----+----
     $0----+----0','----+----0----+----0----+----0----+----0')
C
C
C-----------------------------------------------------------C
C     THIS SECTION WRITES OUT AN ERROR MESSAGE INDICATING   C
C     AN INVALID VALUE FOR FLAG AND THE VALUE THAT WAS      C
C     GIVEN.                                                C
C-----------------------------------------------------------C
C
C
   12 WRITE (IPR,13) FLAG
C
C
   13 FORMAT (//' ** M0088 ** ERROR DETECTED BY SUBROUTINE WRCARD'/19X,
     $      'REQUESTED OPTION (',I4,') IS NOT SUPPORTED')
C
cx    CALL CCEXIT (88)
C
      ENTRY WRCRD
C
      ENTRY CRDPT
C
   14 RETURN
      END
