/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <cu_defs.h>

main(argc, argv)
int argc; char **argv;
{

  Display *dpy;
  int screen;
  int status;
  Cursor cursor;
  XEvent event;
  XWindowAttributes win_attr;
  Window target_win = None;
  Window root = None;
  Window root_rtn, child_rtn;
  char id_input[24];
  int root_x_rtn, root_y_rtn;
  int win_x_rtn, win_y_rtn;
  unsigned int mask_rtn;
  int buttons = 0;
  int getwin = 0;
  int i,total,sleeptime;
  int help,warp;
  int C_ARGIS();

  XEnterWindowEvent WEnterEvent;
  XButtonPressedEvent BPressEvent;
  XButtonReleasedEvent BReleaseEvent;

  if ((C_ARGIS("-h",&argc,argv) == 1) || 
	(C_ARGIS("-?",&argc,argv) == 1)) {
    fprintf(stderr,"Usage: xbtnpress [-getid] [-getxy] \n");
    fprintf(stderr,"       xbtnpress [-id windowid] [-x x-coord] ");
    fprintf(stderr,"[-y y-coord] [-n count] [-i interval]");
    fprintf(stderr," [-warp]\n\n");
    fprintf(stderr,
	"\tRunning with the \"-getid\" is a simple request of the\n");
    fprintf(stderr,
	"\tlowest level widget at the location at which the user\n");
    fprintf(stderr,
	"\tpresses the button. If the x and y location are also \n");
    fprintf(stderr,"\tneeded, the \"-getxy\" option will cause those to\n");
    fprintf(stderr,"\tbe returned. Using the \"-id\" option requests\n");
    fprintf(stderr,
	"\tthat ButtonPress events be sent to the specified \n");
    fprintf(stderr,
	"\twindow. The number of events to be sent is denoted \n");
    fprintf(stderr,
	"\twith the \"-n\" option and the interval between them \n");
    fprintf(stderr,
	"\tis specified by the \"-i\" option. If neither \"-getid\"\n");
    fprintf(stderr,
	"\tnor \"-id\" is specified, the targeted window is first\n");
    fprintf(stderr,
	"\tselected via the mouse and events are then sent to the\n");
    fprintf(stderr,
	"\tselected window. The \"-warp\" option is used to warp the \n");
    fprintf(stderr,
	"\tcursor physically to the target win on each button press.\n");
    exit(0);
    }

  /* open the display */
  if ((dpy = XOpenDisplay((char*)0)) == NULL) {
       fprintf(stderr,"%s: can't open display.\n", **argv);
       exit(1);
  }

  screen = DefaultScreen(dpy);
  root = RootWindow(dpy,screen);

  C_ARGSTR("-id",&id_input[0],"0","0",&argc,argv);
  if ((char *)strstr(id_input,"0x") == (char *)&id_input[0]) {
     sscanf(&id_input[2],"%8x",(int *)&target_win);
     }
  else {
     sscanf(&id_input[0],"%d",&target_win);
     }

  warp = C_ARGIS("-warp",&argc,argv);
/*
 * if "-id" was not specified, we need to get the button's windowid
 */

  if (target_win == 0) {

  /* Make the target cursor */
  cursor = XCreateFontCursor(dpy, XC_crosshair);

  /* Grab the pointer using target cursor, letting it room all over */
  status = XGrabPointer(dpy, root, False,
			ButtonPressMask|ButtonReleaseMask, GrabModeSync,
			GrabModeAsync, None, cursor, CurrentTime);
  if (status != GrabSuccess) {
       fprintf(stderr,"Can''t grab mouse!\n");
       exit(1);
  }

  fprintf(stderr,"Place the crosshair cursor at the desired location and press the mouse button\n");
       
  /* Let the user select a window... */
  while ((target_win == None) || (buttons != 0)) {
    /* allow one more event */
    XAllowEvents(dpy, SyncPointer, CurrentTime);
    XWindowEvent(dpy, root, ButtonPressMask|ButtonReleaseMask, &event);
    switch (event.type) {
    case ButtonPress:
	 target_win = event.xbutton.window;
	 child_rtn = event.xbutton.subwindow;

	 while (child_rtn != None) {
	      target_win = child_rtn;
	      XQueryPointer(dpy, target_win, &root_rtn, &child_rtn,
			    &root_x_rtn, &root_y_rtn, &win_x_rtn, &win_y_rtn,
			    &mask_rtn);
	 }

	 memcpy(&BPressEvent,&event,sizeof(BPressEvent));
	 buttons++;
	 break;
    case ButtonRelease:
      if (buttons > 0) /* there may have been some down before we started */
	buttons--;
       memcpy(&BReleaseEvent,&event,sizeof(BReleaseEvent));
       break;
    }
  } 

  XUngrabPointer(dpy, CurrentTime);      /* Done with pointer */
  XSynchronize(dpy,True);
  XFlush(dpy);
/*
 * if "-getid" was specified, we just print the window id and exit.
 */
  if ( C_ARGIS("-getid",&argc,argv) != 0) {
    fprintf(stdout,"%d", target_win);
    if ( C_ARGIS("-getxy",&argc,argv) != 0) {
      fprintf(stdout," %d %d", win_x_rtn,win_y_rtn);
      }
    fprintf(stdout,"\n");
    fflush(stdout);
    exit(0);
    }
  }
  else {
    if (warp != 0) {
      XGetWindowAttributes(dpy,target_win,&win_attr);
      }
    C_ARGI4("-x",&win_x_rtn,0,0,&argc,argv);
    if (win_x_rtn == 0) win_x_rtn = win_attr.width/2;
    C_ARGI4("-y",&win_y_rtn,0,0,&argc,argv);
    if (win_y_rtn == 0) win_y_rtn = win_attr.height/2;
    }

  memset(&BPressEvent,0,sizeof(BPressEvent));
  BPressEvent.type = ButtonPress;
  BPressEvent.window = target_win;
  BPressEvent.subwindow = None;
  BPressEvent.state = Button1Mask;
  BPressEvent.button = Button1;
  BPressEvent.x = win_x_rtn;
  BPressEvent.y = win_y_rtn;
  memcpy(&WEnterEvent,&BPressEvent,sizeof(BPressEvent));
  WEnterEvent.type = EnterNotify;
  WEnterEvent.state = 0;
  WEnterEvent.x = win_x_rtn;
  WEnterEvent.y = win_y_rtn;
  memcpy(&BReleaseEvent,&BPressEvent,sizeof(BPressEvent));
  BReleaseEvent.type = ButtonRelease;
  BReleaseEvent.window = target_win;
  BReleaseEvent.subwindow = None;
  BReleaseEvent.state = Button1Mask;
  BReleaseEvent.x = win_x_rtn;
  BReleaseEvent.y = win_y_rtn;
#ifdef DEBUG
  fprintf(stderr,"target_win is %X\n", target_win);
  fprintf(stderr,"x = %d y = %d\n", win_x_rtn,win_y_rtn);
  fprintf(stderr,"target_win is %X\n", target_win);
  fprintf(stderr,"press button is %d\n", BPressEvent.button);
  fprintf(stderr,"release button is %d\n", BReleaseEvent.button);
#endif

  C_ARGI4("-n",&total,1,1,&argc,argv);
  C_ARGI4("-i",&sleeptime,0,0,&argc,argv);

  for (i=0; i < total; i++, sleep(sleeptime)) {
      if (warp != 0)
      XWarpPointer(dpy,None,target_win,0,0,0,0,win_x_rtn,win_y_rtn);
      if (XSendEvent(dpy, target_win, True, EnterWindowMask,
		 (XEvent *) &WEnterEvent) == 0) exit(0);

      if (XSendEvent(dpy, target_win, True, ButtonPressMask|ButtonReleaseMask,
		 (XEvent *) &BPressEvent) == 0) {
	fprintf(stderr,"XSendEvent for ButtonPress event failed\n");
	exit(0);
	}

      if (XSendEvent(dpy, target_win, True, ButtonPressMask|ButtonReleaseMask,
		 (XEvent *) &BReleaseEvent) == 0) {
	fprintf(stderr,"XSendEvent for ButtonRelease event failed\n");
	exit(0);
	}
      XFlush(dpy);
      }
 exit(0);
}
