/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <sys/param.h>
#include <string.h>
#include <pwd.h>

#ifdef CRAY
#define MAXPATHLEN PATH_MAX
#endif

static char newpath[MAXPATHLEN];

char *tilde(path) /* expand ~userid path */
char *path;
{
	register char *dir, *p, *b;
	register struct passwd *pwd;
	char *getenv();

	if (*path != '~')
		return strcpy(newpath, path);

	if (path[1] == '\0' || strcmp(path,"~/") == 0)
		return strcpy(newpath, (dir = getenv("HOME")) ? dir : path);

	if (strstr(path,"~/") == path) {
		strcpy(newpath, (dir = getenv("HOME")) ? dir : path);
		return (dir ? strcat(newpath, &path[1]) : newpath);
	}

	for (p = &path[1], b = newpath; *p && (*p != '/'); *b++ = *p++)
		;

	*b = '\0';

	if (!(pwd = getpwnam(newpath)))
		return strcpy(newpath, path);

	strcpy(newpath,pwd->pw_dir);

	return strcat(newpath, p);

}
