/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* xbuttonpanel.c -- simple panel program for EXPLORE */
/* written 09sep90 by Steven Farmer */
/* revised 08feb91 by Phil Fincannon -- converted to X11R4 Motif */
/* revised 23jun93 by phil fincannon -- added scrollbar for large panels */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <Xm/Text.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <errno.h>

#include <sys/param.h>

#ifdef CRAY
#include <sys/wait.h>
#define MAXPATHLEN PATH_MAX
#endif

#define BUTTONTHRESH 2

#define XSET(a,n,v) {Arg *t=&(a); t->name=(n); t->value=(XtArgVal)(v);}
#define XDEF(str)   XmStringCreateLtoR((str),XmSTRING_DEFAULT_CHARSET)

static XtAppContext context;
static Widget shell, form2, form3, scroll, panel, button;
static Arg arg[19];

static Dimension   wid, hgt, width, height;
static Screen      *scrn;
static int leaveup = 0, execcheck= 0, leftflag= 0, align = 0;
static int ac=0, center=0, nrows=0, ncols=0;
static char *labl[1000], *cmnd[1000];
extern void chdirCB ();

char *help = NULL;
char *extcmd = NULL;

#define MAXMSG	256

typedef struct {
	char *iconfile;
	Boolean useButtonLabel;
} ApplicationData, *ApplicationDataPtr;

static String app_defs[] = { NULL };
static XrmOptionDescRec opts[] = {
   { "-iconfile", "*iconfile", XrmoptionSepArg, NULL}
};
static XtResource resources[] = {
   { "iconfile", "Iconfile", XtRString, sizeof(char *),
       XtOffset(ApplicationDataPtr,iconfile), XtRString, NULL},
   { "useButtonLabel", "UseButtonLabel", XtRBoolean, sizeof(Boolean),
       XtOffset(ApplicationDataPtr,useButtonLabel), XtRString, "FALSE"}
};

char *progname;

/*------------------------------------------------------------------*/

main (argc, argv)
   int argc; 
   char *argv[];
{

   extern int  builtin(), canexec();
   extern void seticon(), centermap(), cant(), nozombies();
   extern char *strcntr(), *basename(), *cmdname();
   extern char *optarg;
   extern int  optind, opterr;

   double atof();
   char   *cmd2;

   Pixmap *getbitmap ();
   extern void runCB(), helpCB(), iconifyCB(), dismissCB();

   Cardinal nb = 0;

   char buttonx[10];
   char *getclass(), /* *appnm = basename(argv[0]), */
		*appnm = NULL,
		*classnm = getclass(&argc,argv);

   char options[81], title[81]; 
   char *col, *cmd, *label, *pixfile;

   int i, na, len, ncols=1, rtn, c, nn, nbuttons=0;

   Display      *display;
   ApplicationData data;
   Pixmap *icon;

   int       width, height;
   Pixmap    pix;
   GC        gc;
   XGCValues values;


/* initialize the Xt library */
      XtToolkitInitialize ();
      context = XtCreateApplicationContext ();
      display = XtOpenDisplay (context, NULL, appnm, classnm,
			       opts, XtNumber(opts), &argc,argv);
      if (!display) {
		fprintf(stderr,"%s: can't open display.\n",basename(argv[0]));
		exit(1);
      }
      shell = XtAppCreateShell (appnm, classnm, applicationShellWidgetClass,
                                display, NULL, 0);
      alert_init (shell);
      chdir_init (shell);
      scroll = shell;

/* get application resources */
      XtGetApplicationResources (shell, &data, resources, 
				 XtNumber(resources), NULL, 0);

      opterr = 0;

/* set command line options */
      while ((c = getopt(argc,argv,"N:LXl")) != -1)
          switch(c) {
    	  case 'N':
	        ncols = atof(optarg);
	        break;
	  case 'L':
	        leaveup++;
	        break;
	  case 'X':
		execcheck++;
		break;
	  case 'l':
		leftflag++;
		align = -1;
		break;
          }

/* read the button descriptions */
      nbuttons = 0;
      while ((rtn = getbutton(stdin, &label, &cmd, "->")) != EOF) {
	 labl[nbuttons] = strdup(label);
	 cmnd[nbuttons] = strdup(cmd);
	 nbuttons++;
      }
        
SCROLLBAR:

/* initialize row-column widget */
      panel = (Widget) XmCreateRowColumn (scroll, "buttons", NULL, 0); 
      XtVaSetValues (panel,
		     XmNpacking, XmPACK_COLUMN,
                     XmNnumColumns, (XtArgVal) ncols,

/* added this and commented out the entryAlignment line to correct
   problems on the SGI - j.m.wade 5/14/98
*/
                     XmNisAligned,	False,
/*
                     XmNentryAlignment,
			leftflag? XmALIGNMENT_BEGINNING : XmALIGNMENT_CENTER,
*/
	   	     NULL);
      opterr = 0;

/* add buttons defined in input file */
      for (nn=0; nn<nbuttons; nn++) {
	 label = labl[nn];
	 cmd = cmnd[nn];
	 if (strcmp(cmd,"LEFT") == 0) {
		align = -1;
		continue;
	 } else
	 if (strcmp(cmd,"CENTER") == 0) {
		align = 0;
		continue;
	 } else
	 if (strcmp(cmd,"RIGHT") == 0) {
		align = 1;
		continue;
	 }
	
	 if (data.useButtonLabel)
	 	button = XmCreatePushButton (panel, label, NULL, 0);
	 else {
         	sprintf (buttonx, "button%d", ++nb);
		 if (rtn == 0) {
		     fprintf (stderr, "xbuttonpanel bad line %d\n", nb);
		     continue;
		 }
	 	button = XmCreatePushButton (panel, buttonx, NULL, 0);
	 }
	 XtAddCallback (button, XmNactivateCallback, runCB, (caddr_t)cmd);
	 XtVaSetValues (button, XmNlabelString, XDEF(label), NULL);

	 if (align == 0)
	 	XtVaSetValues (button, XmNalignment,XmALIGNMENT_CENTER, NULL);
	 else if (align < 0)
		XtVaSetValues (button, XmNalignment,XmALIGNMENT_BEGINNING,NULL);
	 else if (align > 0)
		XtVaSetValues (button, XmNalignment,XmALIGNMENT_END, NULL);

         cmd2 = cmdname (cmd);
	 if (execcheck && !builtin(cmd2) && !canexec(cmd2)) {
	     if (!(!strcmp(cmd2,"CHDIR") ||
		   !strcmp(cmd2,"ICONIFY") ||
		   !strcmp(cmd2,"DISMISS"))) XtSetSensitive (button, FALSE);
	 }
	 if (!strncmp(cmd2,"INACTIVE", 8)) XtSetSensitive (button, FALSE);

	 if (*label == '@') {
	     pixfile = label + 1;
	     icon = getbitmap (shell, pixfile);

	     if (icon != NULL) {
		 width = 32;
		 height = 32;

                 XtVaGetValues (button, XtNforeground, &values.foreground,
		                XtNbackground, &values.background, NULL);

                 gc = XtGetGC (button, GCForeground|GCBackground, &values);
    
                 pix = XCreatePixmap (XtDisplay(button), 
		                      RootWindowOfScreen(XtScreen(button)),
			              width, height,
				      DefaultDepthOfScreen(XtScreen(button)));

                 XCopyPlane (XtDisplay(button), *icon, pix, gc, 0,0,
		             width,height, 0,0, 1);

		 XtVaSetValues (button, XmNlabelPixmap, pix,
					XmNuserData,    pix,
	        	                XmNlabelType, XmPIXMAP, NULL);
	     }
	 }
         XtManageChild (button);
      }

/* zap old processes */
      if ((int)signal(SIGCHLD,SIG_IGN) < 0) {
/*
      if (signal(SIGCHLD,nozombies) < 0) {
*/
	 perror ("main (signal)");
	 exit(1); 
      }

      XtManageChild (panel);
      if (scroll != shell) XtManageChild (scroll);   

      XtVaSetValues (shell, XmNmappedWhenManaged, FALSE, NULL);
      XtRealizeWidget (shell);
      if (data.iconfile) seticon (shell, data.iconfile);

      if (scroll==shell) {
          scrn = XtScreen(shell);
          wid = WidthOfScreen(scrn);
          hgt = HeightOfScreen(scrn);
          XtVaGetValues (panel, XmNwidth, &width, XmNheight, &height, NULL);  
          if (height > 65565) height/=65565;
          if (width  > 65565) width /=65565;

          if (height > hgt || width > wid) {
	      XtUnrealizeWidget (panel);
	      if (height > hgt) { height = hgt - 200; width += 36; }
	      if (width  > wid) { width = wid - 100; height += 36; }
	      if (height > hgt) { height = hgt - 200; width += 36; }
	      XtVaSetValues (shell, XmNwidth, width, XmNheight, height, NULL);
	      ac = 0;
  	      XSET (arg[ac++], XmNwidth, width);   
  	      XSET (arg[ac++], XmNheight, height);      
	      XSET (arg[ac++], XmNscrollingPolicy, XmAUTOMATIC);  
              scroll = (Widget)XmCreateScrolledWindow(shell,"scroll",arg,ac);
	      goto SCROLLBAR;
          }
      }

      centermap (shell); 

      XtAppMainLoop (context);
}

/*------------------------------------------------------------------*/

void
cant (cmd)
   char *cmd;
{
	/* extern char *sys_errlist[]; */

	char msg[MAXPATHLEN+MAXMSG];

        sscanf (cmd, "%s", msg);	
	strcat (msg, " : ");

/* - changed for portability - 10/19/00 - joe m. wade

	strcat (msg, errno > 0 && errno < sys_nerr ?
		     sys_errlist[errno] : "can't execute.");
*/
	strcat (msg, errno > 0 ?
		     strerror(errno) : "can't execute.");
/*
{
	char *errmsg;
	if (errno > 0) {
	  errmsg = strerror(errno);
	  strcat(msg,errmsg);
	  }
	else
	  strcat(msg,"can't execute.");
}
*/

	alert (msg);
	return;
}

/*------------------------------------------------------------------*/

void
helpCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data;
{
      char *str = (char *) client_data;

      alert (str);
}

/*------------------------------------------------------------------*/

void
iconifyCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data;
{
      XIconifyWindow (XtDisplay(w), XtWindow((Widget)shell),
	              XScreenNumberOfScreen(XtScreen(w)));
      XFlush (XtDisplay(w));
      return;
}

/*------------------------------------------------------------------*/

void
dismissCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data; 
{
	XtUnmapWidget (shell);
        XtDestroyApplicationContext (context);
        exit(0);
}

/*------------------------------------------------------------------*/

void
disarmTO (w, timer)
   Widget w;
   XtIntervalId *timer;
{
	XtSetSensitive (w, TRUE);
}

/*------------------------------------------------------------------*/

void
runCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data; 
{
	int   istat;

	extern char *cmdname();

	char *cmd = (char *) client_data;
	char *cmd2;
	static long tstamp = 0.0;
	long msec = 4000;
	XtIntervalId timer;

/*	if (ignoreevent((long)BUTTONTHRESH,&tstamp)) goto retn; */

        cmd2 = cmdname (cmd);

        if (!strcmp(cmd2,"DISMISS")) {
	    dismissCB (w, client_data, call_data);
	}

	if (!strcmp(cmd2,"CHDIR")) {
	    chdirCB (w, client_data, call_data);
	    goto retn;
	}

	if (!strcmp(cmd2,"ICONIFY")) {
	    iconifyCB (w, client_data, call_data);
	    goto retn;
	}

	if (!builtin(cmd2) && !canexec(cmd2)) {
	    syserr (cmd, "cannot execute?");
	    goto retn;
	}

	if (!canexec("sh")) {
	    syserr ("sh", "cannot execute??");
	    goto retn;
	}

	if (leaveup) {
	    XtSetSensitive (w, FALSE);
	    timer = XtAppAddTimeOut (context, msec, disarmTO, w);
	    istat = runcmd (cmd);
	} else {
	    XtUnmapWidget (shell);
            XtDestroyApplicationContext (context);
	    execcmd (cmd);
	}

   retn:
	return;
}

#ifndef CRAY
/*------------------------------------------------------------------*/

#include <sys/wait.h>

/*
void nozombies (sig, code, scp, addr)
   int sig, code;
   struct sigcontext *scp;
   char *addr;
*/
void nozombies ()
{
/*
	union wait wstatus;
*/
	int wstatus;

/*
	while (wait3(&wstatus,WNOHANG,NULL) > 0)
		;
*/
	while (waitpid(-1,&wstatus,WNOHANG) > 0);

/*
        if (signal(SIGCHLD,nozombies) < 0) {
*/
        if ((int)signal(SIGCHLD,nozombies) < 0) {
                perror("main (signal)");
                exit(1);
        }
}
#endif
