/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>
#include <xcat_defs.h>

char *string,*text;
char msg_text[64];
XmString ok_string,error_string;

void destroy_dialog(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XtDestroyWidget((Widget) client_data);
}
void drop_dialog(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XtUnmanageChild((Widget) client_data);
}

void got_file_name(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	FILE *file;
	XmTextPosition last_char;
	void newfile();

	XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)call_data)->value,
	  XmSTRING_DEFAULT_CHARSET,&string);

	file = fopen(string,"w");
	if (file == NULL) {
	  Widget error;
	  error = XmCreateErrorDialog(((Memory *) client_data)->widget,
		"file_error",NULL,0);
	  sprintf(msg_text,"Could not open file %s for writing",string);
	  ok_string = XmStringCreateLtoR("Reenter",XmSTRING_DEFAULT_CHARSET);
	  error_string = XmStringCreateLtoR(msg_text,
		XmSTRING_DEFAULT_CHARSET);
	  XtVaSetValues (error, 
		XmNmessageString, 	error_string,
		XmNokLabelString, 	ok_string,
		NULL);
	  XtAddCallback(error,XmNokCallback,newfile,client_data);
	  XtAddCallback(error,XmNokCallback,destroy_dialog,error);
	  XtAddCallback(error,XmNcancelCallback,destroy_dialog,error);
	  XtAddCallback(error,XmNcancelCallback,destroy_dialog,widget);
	  XtManageChild(error);
	  return;
	  }
	text = XmTextGetString(((Memory *) client_data)->widget);
	fprintf(file,"%s",text);
	last_char = XmTextGetLastPosition(((Memory *) client_data)->widget) - 1;
	if ((last_char >= 0) && (text[last_char] != '\n')) 
	  fprintf(file,"\n",text);
	fclose(file);

        XtDestroyWidget(widget);
}

void newfile(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	Widget dialog;

	dialog = XmCreateFileSelectionDialog(widget,"SaveFileDG",NULL,0);
	XtVaSetValues(dialog,
		XmNtitle,	"XCat Save File Dialog",
		NULL);
	XtManageChild(dialog);
	XuSet_Help(dialog,"Save_Dsc.help");
/*
  I know this is extreme, but the previously used *editable option for
  xcat affected these child widgets.
*/ 
	XtVaSetValues(XmFileSelectionBoxGetChild(dialog,XmDIALOG_TEXT),
		XmNeditable,	TRUE,
		NULL);
	XtVaSetValues(XmFileSelectionBoxGetChild(dialog,XmDIALOG_FILTER_TEXT),
		XmNeditable,	TRUE,
		NULL);

	XtAddCallback(dialog,XmNokCallback,got_file_name,client_data);
	XtAddCallback(dialog,XmNcancelCallback,destroy_dialog,dialog);
}

void oldfile(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	Widget dialog;
	XmString oldfilename;

	oldfilename = XmStringCreate(((Memory *) client_data)->filename,
		XmSTRING_DEFAULT_CHARSET);

	dialog = XmCreateFileSelectionDialog(widget,"SaveFileDG",NULL,0);

	XtVaSetValues(dialog,
		XmNtitle,	"XCat Save File Dialog",
		XmNtextString,	oldfilename,
		NULL);

	XtManageChild(dialog);
	XuSet_Help(dialog,"Save_Dsc.help");
	XtVaSetValues(XmFileSelectionBoxGetChild(dialog,XmDIALOG_TEXT),
		XmNeditable,	TRUE,
		NULL);
	XtVaSetValues(XmFileSelectionBoxGetChild(dialog,XmDIALOG_FILTER_TEXT),
		XmNeditable,	TRUE,
		NULL);

	XtAddCallback(dialog,XmNokCallback,got_file_name,client_data);
	XtAddCallback(dialog,XmNcancelCallback,destroy_dialog,dialog);
}
