/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
    this routine is built by the script gensiglu and is designed
    to build a translation mechanism from a signal name in ascii
    form to the corresponding numeric signal in /usr/include/signal.h
    if it exists.
                               - joe m. wade 4/2/96
*/
#include <stdio.h>
#include <signal.h>

int siglu(signame)
char *signame;
{
  if (strlen(signame)	== 0) return SIGKILL;
#ifdef SIG32
  else if (strcmp(signame,"32")	== 0) return SIG32;
#endif
#ifdef SIGABRT
  else if (strcmp(signame,"ABRT")	== 0) return SIGABRT;
#endif
#ifdef SIGALRM
  else if (strcmp(signame,"ALRM")	== 0) return SIGALRM;
#endif
#ifdef SIGARRAYSIZE
  else if (strcmp(signame,"ARRAYSIZE")	== 0) return SIGARRAYSIZE;
#endif
#ifdef SIGBUFIO
  else if (strcmp(signame,"BUFIO")	== 0) return SIGBUFIO;
#endif
#ifdef SIGBUS
  else if (strcmp(signame,"BUS")	== 0) return SIGBUS;
#endif
#ifdef SIGCHLD
  else if (strcmp(signame,"CHLD")	== 0) return SIGCHLD;
#endif
#ifdef SIGCLD
  else if (strcmp(signame,"CLD")	== 0) return SIGCLD;
#endif
#ifdef SIGCONT
  else if (strcmp(signame,"CONT")	== 0) return SIGCONT;
#endif
#ifdef SIGCPULIM
  else if (strcmp(signame,"CPULIM")	== 0) return SIGCPULIM;
#endif
#ifdef SIGCRAY10
  else if (strcmp(signame,"CRAY10")	== 0) return SIGCRAY10;
#endif
#ifdef SIGCRAY11
  else if (strcmp(signame,"CRAY11")	== 0) return SIGCRAY11;
#endif
#ifdef SIGCRAY12
  else if (strcmp(signame,"CRAY12")	== 0) return SIGCRAY12;
#endif
#ifdef SIGCRAY13
  else if (strcmp(signame,"CRAY13")	== 0) return SIGCRAY13;
#endif
#ifdef SIGCRAY14
  else if (strcmp(signame,"CRAY14")	== 0) return SIGCRAY14;
#endif
#ifdef SIGCRAY4
  else if (strcmp(signame,"CRAY4")	== 0) return SIGCRAY4;
#endif
#ifdef SIGCRAY5
  else if (strcmp(signame,"CRAY5")	== 0) return SIGCRAY5;
#endif
#ifdef SIGCRAY6
  else if (strcmp(signame,"CRAY6")	== 0) return SIGCRAY6;
#endif
#ifdef SIGCRAY7
  else if (strcmp(signame,"CRAY7")	== 0) return SIGCRAY7;
#endif
#ifdef SIGCRAY8
  else if (strcmp(signame,"CRAY8")	== 0) return SIGCRAY8;
#endif
#ifdef SIGCRAY9
  else if (strcmp(signame,"CRAY9")	== 0) return SIGCRAY9;
#endif
#ifdef SIGDEFER
  else if (strcmp(signame,"DEFER")	== 0) return SIGDEFER;
#endif
#ifdef SIGDIL
  else if (strcmp(signame,"DIL")	== 0) return SIGDIL;
#endif
#ifdef SIGDLK
  else if (strcmp(signame,"DLK")	== 0) return SIGDLK;
#endif
#ifdef SIGEMT
  else if (strcmp(signame,"EMT")	== 0) return SIGEMT;
#endif
#ifdef SIGERR
  else if (strcmp(signame,"ERR")	== 0) return SIGERR;
#endif
#ifdef SIGFPE
  else if (strcmp(signame,"FPE")	== 0) return SIGFPE;
#endif
#ifdef SIGFREEZE
  else if (strcmp(signame,"FREEZE")	== 0) return SIGFREEZE;
#endif
#ifdef SIGHOLD
  else if (strcmp(signame,"HOLD")	== 0) return SIGHOLD;
#endif
#ifdef SIGHUP
  else if (strcmp(signame,"HUP")	== 0) return SIGHUP;
#endif
#ifdef SIGHWE
  else if (strcmp(signame,"HWE")	== 0) return SIGHWE;
#endif
#ifdef SIGIGNORE
  else if (strcmp(signame,"IGNORE")	== 0) return SIGIGNORE;
#endif
#ifdef SIGILL
  else if (strcmp(signame,"ILL")	== 0) return SIGILL;
#endif
#ifdef SIGINFO
  else if (strcmp(signame,"INFO")	== 0) return SIGINFO;
#endif
#ifdef SIGINT
  else if (strcmp(signame,"INT")	== 0) return SIGINT;
#endif
#ifdef SIGIO
  else if (strcmp(signame,"IO")	== 0) return SIGIO;
#endif
#ifdef SIGIOT
  else if (strcmp(signame,"IOT")	== 0) return SIGIOT;
#endif
#ifdef SIGKILL
  else if (strcmp(signame,"KILL")	== 0) return SIGKILL;
#endif
#ifdef SIGLOST
  else if (strcmp(signame,"LOST")	== 0) return SIGLOST;
#endif
#ifdef SIGLWP
  else if (strcmp(signame,"LWP")	== 0) return SIGLWP;
#endif
#ifdef SIGMASK
  else if (strcmp(signame,"MASK")	== 0) return SIGMASK;
#endif
#ifdef SIGMT
  else if (strcmp(signame,"MT")	== 0) return SIGMT;
#endif
#ifdef SIGMTKILL
  else if (strcmp(signame,"MTKILL")	== 0) return SIGMTKILL;
#endif
#ifdef SIGNOBDM
  else if (strcmp(signame,"NOBDM")	== 0) return SIGNOBDM;
#endif
#ifdef SIGORE
  else if (strcmp(signame,"ORE")	== 0) return SIGORE;
#endif
#ifdef SIGPAUSE
  else if (strcmp(signame,"PAUSE")	== 0) return SIGPAUSE;
#endif
#ifdef SIGPIPE
  else if (strcmp(signame,"PIPE")	== 0) return SIGPIPE;
#endif
#ifdef SIGPOLL
  else if (strcmp(signame,"POLL")	== 0) return SIGPOLL;
#endif
#ifdef SIGPRE
  else if (strcmp(signame,"PRE")	== 0) return SIGPRE;
#endif
#ifdef SIGPROF
  else if (strcmp(signame,"PROF")	== 0) return SIGPROF;
#endif
#ifdef SIGPWR
  else if (strcmp(signame,"PWR")	== 0) return SIGPWR;
#endif
#ifdef SIGQUIT
  else if (strcmp(signame,"QUIT")	== 0) return SIGQUIT;
#endif
#ifdef SIGRECOVERY
  else if (strcmp(signame,"RECOVERY")	== 0) return SIGRECOVERY;
#endif
#ifdef SIGRELSE
  else if (strcmp(signame,"RELSE")	== 0) return SIGRELSE;
#endif
#ifdef SIGRPE
  else if (strcmp(signame,"RPE")	== 0) return SIGRPE;
#endif
#ifdef SIGRTMAX
  else if (strcmp(signame,"RTMAX")	== 0) return SIGRTMAX;
#endif
#ifdef SIGRTMIN
  else if (strcmp(signame,"RTMIN")	== 0) return SIGRTMIN;
#endif
#ifdef SIGSEGV
  else if (strcmp(signame,"SEGV")	== 0) return SIGSEGV;
#endif
#ifdef SIGSHUTDN
  else if (strcmp(signame,"SHUTDN")	== 0) return SIGSHUTDN;
#endif
#ifdef SIGSTKSZ
  else if (strcmp(signame,"STKSZ")	== 0) return SIGSTKSZ;
#endif
#ifdef SIGSTOP
  else if (strcmp(signame,"STOP")	== 0) return SIGSTOP;
#endif
#ifdef SIGSYS
  else if (strcmp(signame,"SYS")	== 0) return SIGSYS;
#endif
#ifdef SIGTERM
  else if (strcmp(signame,"TERM")	== 0) return SIGTERM;
#endif
#ifdef SIGTHAW
  else if (strcmp(signame,"THAW")	== 0) return SIGTHAW;
#endif
#ifdef SIGTRAP
  else if (strcmp(signame,"TRAP")	== 0) return SIGTRAP;
#endif
#ifdef SIGTSTP
  else if (strcmp(signame,"TSTP")	== 0) return SIGTSTP;
#endif
#ifdef SIGTTIN
  else if (strcmp(signame,"TTIN")	== 0) return SIGTTIN;
#endif
#ifdef SIGTTOU
  else if (strcmp(signame,"TTOU")	== 0) return SIGTTOU;
#endif
#ifdef SIGUME
  else if (strcmp(signame,"UME")	== 0) return SIGUME;
#endif
#ifdef SIGURG
  else if (strcmp(signame,"URG")	== 0) return SIGURG;
#endif
#ifdef SIGUSR1
  else if (strcmp(signame,"USR1")	== 0) return SIGUSR1;
#endif
#ifdef SIGUSR2
  else if (strcmp(signame,"USR2")	== 0) return SIGUSR2;
#endif
#ifdef SIGVTALRM
  else if (strcmp(signame,"VTALRM")	== 0) return SIGVTALRM;
#endif
#ifdef SIGWAITING
  else if (strcmp(signame,"WAITING")	== 0) return SIGWAITING;
#endif
#ifdef SIGWINCH
  else if (strcmp(signame,"WINCH")	== 0) return SIGWINCH;
#endif
#ifdef SIGWINDOW
  else if (strcmp(signame,"WINDOW")	== 0) return SIGWINDOW;
#endif
#ifdef SIGWRBKPT
  else if (strcmp(signame,"WRBKPT")	== 0) return SIGWRBKPT;
#endif
#ifdef SIGXCPU
  else if (strcmp(signame,"XCPU")	== 0) return SIGXCPU;
#endif
#ifdef SIGXFSZ
  else if (strcmp(signame,"XFSZ")	== 0) return SIGXFSZ;
#endif
  else {
	fprintf(stderr,"signal %s not recognized: SIGKILL used\\n",signame);
	return SIGKILL;
       }
}
