/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "field.h"
#include <stdlib.h>

intcktype(f,value) /* make sure value is an integer */
Field *f; char *value;
{
	void doalert();

	if (isint(value))
		return 0;
	else {
		char msg[255];
		sprintf(msg,"%s must be an integer.",f->f_name);
		doalert(msg);
		return 1;
	}

}

intckmax(f,value) /* check value against f_maxv */
Field *f; char *value;
{
	void doalert();

	double atof();

	if (atof(value) > atof(f->f_maxv)) {
		char msg[255];
		sprintf(msg,"%s can't be greater than %s",f->f_name,f->f_maxv);
		doalert(msg);
		return 1;
	}

	return 0;
}

intckmin(f,value) /* check value against f_fmin */
Field *f; char *value;
{
	void doalert();

	double atof();

	if (atof(value) < atof(f->f_minv)) {
		char msg[255];
		sprintf(msg,"%s can't be less than %s",f->f_name,f->f_minv);
		doalert(msg);
		return 1;
	}

	return 0;
}
