/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>

static int buf[BUFSIZ], bp = -1;

ngetc() /* return (possibly pushed back) char */
{
	int c;

	if (bp > -1)
		c = buf[bp];
	else {
		bp = 0;
		buf[bp] = c = getc(stdin);
	}

	if (c != EOF)
		bp--;

	return(c);

}

void putbak(c) /* put c back on to input */
int c;
{
	if (++bp > BUFSIZ)
		synerr("putbak","too many characters pushed back.");

	buf[bp] = c;

}

void pbstr(str) /* put back string via putbak */
char str[];
{
	int i;

	for (i = strlen(str) - 1; i > -1; --i) 
		putbak((int)str[i]);

}
