/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <string.h>
#include <stdlib.h>
#include "field.h"

pathckmax(f,value) /* check length of each path component against max */
Field *f; char *value;
{
	double atof();

	char *p = value;

	int n = 0, maxlen = atof(f->f_maxv);

	for (; *p; p++)
		if (*p != '/')
			n++;
		else if (p != value && n > maxlen)
			break;
		else n = 0;

	if (n > maxlen) {
		char msg[255];
		sprintf(msg,
		"%s: no path component can exceed %d character%s",
		f->f_name,maxlen,(maxlen == 1 ? "" : "s"));		
		doalert(msg);
		return 1;
	}

	return 0;
				
}
