/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* 19mar90 Steven Farmer  - original development */
/* 19mar91 Phil Fincannon - converted from sunview to x11r4 */
/* 14feb92 phil fincannon - added precision keyword for slider */
/* 14feb92 phil fincannon - added on  keyword for toggle       */
/* 14feb92 phil fincannon - added off keyword for toggle       */
/* 14feb92 phil fincannon - added S option for string list     */
/* 17feb92 phil fincannon - removed '_' for single blank       */
/* 18feb92 phil fincannon - added precision option for real    */
/* 20feb92 phil fincannon - added zero (0) default for real&int*/
/* 28apr92 phil fincannon - added script checking for slider   */
/* 28apr92 phil fincannon - added script checking for toggle   */
/* 05jun92 phil fincannon - added allwhite test                */
/* 28aug92 phil fincannon - allow %tag extended script testing */
/* 17sep92 phil fincannon - correct toggle/slider errors       */
/* 24sep92 phil fincannon - added toggle2 type                 */
/* 19jul93 Steven Farmer  - widget names set to field names    */
/* 20jul93 Steven Farmer  - added password type		       */
/* 10sep93 phil fincannon - added select option                */
/* 17sep93 phil fincannon - added pick option                  */
/* 15nov93 phil fincannon - new alert warning for file write er*/
/* 08dec93 phil fincannon - uppercase keyword option           */
/* 07aug01 joe m. wade    - upped MAXSEL to 4096               */

#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <errno.h>
#include "field.h"
#include "global_defs.h"

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Protocols.h>
#include <Xm/BulletinB.h>
#include <Xm/SelectioB.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

#define MIN(a,b)	((a)<(b) ? (a) : (b))
#define MAX(a,b)	((a)>(b) ? (a) : (b)) 

#define NORMALEXIT	0400

#define OK 1
#define CANCEL 2

#define XSET(a,n,v) {Arg *t=&(a); t->name=(n); t->value=(XtArgVal)(v);}
#define XDEF(str)   XmStringCreateLtoR((str),XmSTRING_DEFAULT_CHARSET)

#define MAXSEL 4096 /* maximum selection widget entrys + 1 */

typedef struct { char *iconfile;
                 char *dismiss;
		 char *help;
		 char *proceed;
} ApplicationData, *ApplicationDataPtr;

static ApplicationData data;

static XrmOptionDescRec opts[] = {
   { "-iconfile", "*iconfile", XrmoptionSepArg, NULL},
   { "-dismiss",  "*dismiss",  XrmoptionSepArg, NULL},
   { "-help",     "*help",     XrmoptionSepArg, NULL},
   { "-proceed",  "*proceed",  XrmoptionSepArg, NULL}
};

static String app_defs[] = { "*dismiss: Dismiss",
			     "*help:    help",
			     "*proceed: Proceed",
			     NULL };

static XtResource resources[] = {
   { "iconfile", "Iconfile", XtRString, sizeof(char *),
     XtOffset(ApplicationDataPtr,iconfile), XtRString, NULL},
   { "dismiss", "Dismiss", XtRString, sizeof(char *),
     XtOffset(ApplicationDataPtr,dismiss), XtRString, NULL},
   { "help", "Help", XtRString, sizeof(char *),
     XtOffset(ApplicationDataPtr,help), XtRString, NULL},
   { "proceed", "Proceed", XtRString, sizeof(char *),
     XtOffset(ApplicationDataPtr,proceed), XtRString, NULL}
};
	     
static Widget xpanel, scrollbar, form2, form, desc;
static Widget value[MAXFIELDS], button[MAXFIELDS], dialog[MAXFIELDS];
static Widget dismissPB, proceedPB, helpPB, selectPB, list, option_menu;
static Widget menu, optn, optnum[99];
static Atom   delete_atom;
static Arg    arg[9];
static int    ac;

extern void widgetree(), centermap(), unmanageCB(), manageCB();
extern void alert_init(), alert();
extern char *remtmpmnt();
extern char *trim(), *ljust(), *sp2undr(), *findval();
/* extern double pow(), atof(); */
extern int rtckfield();


char *envfile = ".explenv";
char *helpcmd = NULL;
char filename[300];
char *item[]={
"one", "two", "three", "four", "five",
"one", "two", "three", "four", "five",
"one", "two", "three", "four", "five",
};
/*
char *item2[202];
*/
char *item2[MAXSEL];	/* changed 1/31/97 - jmw - selectrd could walk out */
char *selct;
char *sel[MAXSEL];

XmString     xmstr;
XtAppContext context;

int leaveup = 0, blanks = 0, debug = 0;

/* -------------------------------------------------------------------- */

void
updatefields (w) /* update tags array from user input */
   Widget  w;
{
	extern int rtckfield();

	char *valu, *valu2;
	char val[20], msg[80];
	Boolean sw;
	int i, ival, idec, rc;
	double power;

        if (debug) fprintf (stderr, "xpanel >updatefields\n");

	for (i = 0; i < nfields; i++) {
           if (debug) fprintf (stderr, "xpanel checkfield %d\n", i);
	   if (flist[i]->f_type == FTLABEL) continue;
	   if (flist[i]->f_type == FTTOGGLE) {
	      XtVaGetValues (value[i], XmNset, &sw, NULL);
	      valu = flist[i]->f_off;
	      if (sw) valu = flist[i]->f_on;
	      setval(flist[i]->f_tag,valu);
	   } else if (flist[i]->f_type == FTSLIDER) {
	      idec = flist[i]->f_prec;
	      if (idec < 0) idec = 0;
	      if (idec > 9) idec = 0;
	      XtVaGetValues (value[i], XmNvalue, &ival, NULL);
	      power = ival;
	      power = power / pow(10.0,(double)idec);
	      sprintf (val, "%.*f", idec, power);
	      valu = &val[0];
	      setval(flist[i]->f_tag,valu);
	   } else {
	      valu = valu2 = trim(ljust(XmTextGetString (value[i])));
	      if (flist[i]->f_uppercase) {
		  while (*valu2) { *valu2 = toupper(*valu2); valu2++; }
	      }
	      if (flist[i]->f_type == FTPWORD && flist[i]->f_pword)
		  valu = flist[i]->f_pword;
	      if (allwhite(valu)) valu = "";        /* 05jun92 pf+ */
	      if (!blanks) valu = sp2undr(valu);
	      
	      if (!strlen(valu) ||                  /* 20feb92 pf+ */
	           strcmp(valu," ") == 0 ||
		   strcmp(valu,"_") == 0) {
	          if (flist[i]->f_type == FTINTEGER) valu = "0";
	          if (flist[i]->f_type == FTREAL) valu = "0";
	      }                                   /* 20feb92 pf+ */
	      
	      if (flist[i]->f_type == FTREAL) {   /* 18feb92 pf+ */
		  idec = flist[i]->f_prec;
		  if (idec>0 && idec<=9) {
		      power = atof (valu);
		      sprintf (val, "%.*f", idec, power);
	              valu = &val[0];
		  }
	      }                                   /* 18feb92 pf+ */

/*	      if (flist[i]->f_type == FTSTRING) {
		  if (strlen(valu) == 1  &&  valu[0] == ' ') valu="_"; 
	      }
17feb92 pf- */
	      
	      /* if (strlen(valu) > 0) {
	          if (flist[i]->f_tag != NULL)  setval(flist[i]->f_tag,valu);
	      } */   
	      setval(flist[i]->f_tag,valu);
	   }
	}
} /* end updatefields */
	
Boolean checkfields(w) /* check every field on panel */
Widget w;
{
	char *valu, *valu2;
	char val[20], msg[80];
	Boolean sw;
	int i, ival, idec, rc;
	double power;

        for (i=0; i<nfields; i++) {
           if (debug) fprintf (stderr, "xpanel chkfield %d\n", i);
           if (flist[i]->f_type == FTLABEL ) continue;
	   valu = findval (flist[i]->f_tag);
           if (rtckfield(flist[i],valu)) {
               XmProcessTraversal (value[i], XmTRAVERSE_CURRENT);
               XtSetSensitive (w, TRUE);
               XmUpdateDisplay (w);
               return(TRUE);
           }
        }
/* 28aug92 pf+ */

        if (debug) fprintf (stderr, "xpanel puttags\n");

	errno = -1;

	if ((rc = puttags(envfile)) != 0) {
		char buf[1024];
		sprintf(buf, "Can't write %s", envfile);
		syserr(buf, "unknown error!");
	}


/* every thing checks out */
        if (debug) fprintf (stderr, "xpanel exit\n");
	if (!leaveup && rc == 0) exit (NORMALEXIT);

        XtSetSensitive (w, TRUE);
	return(TRUE);
} /* end checkfields */

/* -------------------------------------------------------------------- */

void
proceedCB (w, client_data, call_data) /* check every field on panel */
    Widget  w;
    caddr_t client_data, call_data;
{
    updatefields(w); /* slf */
    XtSetSensitive (w, FALSE);
    XtAppAddWorkProc (context, (XtWorkProc) checkfields, w);
    XmUpdateDisplay (w);
}

/* -------------------------------------------------------------------- */

/* this routine is from the FAQ */
void
pwordCB(text_w, pfield, cbs)
Widget        text_w;
Field	      *pfield;
XmTextVerifyCallbackStruct *cbs;
{
    char *new;
    int len;

    if (cbs->reason == XmCR_ACTIVATE) {
        return;
    }
 
    if (cbs->text->ptr == NULL) { /* backspace */
        cbs->endPos = strlen(pfield->f_pword); /* delete from here to end */
        if (cbs->endPos <= 0) return; /* catch null passwd - Mark Scoville */
        pfield->f_pword[cbs->startPos] = 0; /* backspace--terminate */
        return;
    }
 
    if (cbs->text->length > 1) {
        cbs->doit = False; /* don't allow "paste" operations */
        return; /* make the user *type* the password! */
    }
 
    new = XtMalloc(cbs->endPos + 2); /* new char + NULL terminator */
    if (pfield->f_pword) {
        strcpy(new, pfield->f_pword);
        XtFree(pfield->f_pword);
    } else
        new[0] = NULL;
    pfield->f_pword = new;
 
    strncat(pfield->f_pword, cbs->text->ptr, cbs->text->length);
    pfield->f_pword[cbs->endPos + cbs->text->length] = 0;

    for (len = 0; len < cbs->text->length; len++)
        cbs->text->ptr[len] = '*';
}

/* -------------------------------------------------------------------- */

void
enableTO (w, timer) 
    Widget w;
    XtIntervalId  timer;
{
    XtSetSensitive (w, TRUE);
}

/* -------------------------------------------------------------------- */

void
helpCB (w, client_data, call_data) /* display help window */
   Widget  w;
   caddr_t client_data, call_data;
{
      char *cmd = (char *) client_data;
      char *cmd2;
      extern char *cmdname();
      int istat;
      long msec = 4000;
      XtIntervalId timer;

      XtSetSensitive (w, FALSE);
      timer = XtAppAddTimeOut (context, msec, (XtTimerCallbackProc)enableTO, w);
      cmd2 = cmdname (cmd);

      if (!canexec(cmd2)) syserr (cmd2, "cannot execute?");
      else istat = runcmd (cmd);
      
}

/* -------------------------------------------------------------------- */

void
quitCB (w, client_data, call_data) /* exit immediately */
   Widget  w;
   caddr_t client_data, call_data;
{
/*    XtCloseDisplay fails for protocol widget */
/*    XtCloseDisplay (XtDisplay(w)); */
      exit (1);
}

/* -------------------------------------------------------------------- */

void
watch_cursor (w)   /* change to wrist watch cursor */
    Widget w;
{ 
    Cursor c1;

    c1 = XCreateFontCursor (XtDisplay(w), XC_watch);
    XDefineCursor (XtDisplay(w), XtWindow(w), c1);
    XFlush (XtDisplay(w));
}

/* -------------------------------------------------------------------- */

void
normal_cursor (w)   /* change to normal cursor */
    Widget w;
{
    XUndefineCursor (XtDisplay(w), XtWindow(w));
    XFlush (XtDisplay(w));
}

/* -------------------------------------------------------------------- */

void
dialogCB (w, i, call_data)
   Widget  w; 
   int i;
   XmSelectionBoxCallbackStruct *call_data;
{
    char *s;

    XtUnmanageChild (w);

    XmStringGetLtoR (call_data->value, XmSTRING_DEFAULT_CHARSET, &s);
    s = remtmpmnt (s);
    /* printf ("dialogCB value='%s'\n", s); */
    XtVaSetValues (value[i], XmNvalue, s, NULL);
    setval(flist[i]->f_tag,s);
    XtFree (s);
}

/* -------------------------------------------------------------------- */

void
selectCB (w, i, call_data) /* manage selection box dialog */
   Widget  w;
   int i;
   caddr_t call_data;
{
   Widget list;
   int rc, m, nitems;
   Boolean bool;
   char *s;

   watch_cursor (xpanel);
   XtSetSensitive (dismissPB, FALSE);
   XtSetSensitive (proceedPB, FALSE);
   XmUpdateDisplay (xpanel);
   XFlush (XtDisplay(w));

   updatefields(w); /* slf */
   list = (Widget) XmSelectionBoxGetChild (dialog[i], XmDIALOG_LIST);
   XmListDeleteAllItems (list);
   XtVaGetValues (value[i], XmNvalue, &s, NULL);
   setval(flist[i]->f_tag,s);
   nitems = selectrd (flist[i]->f_select, &rc, MAXSEL-1, item2);
   XFlush (XtDisplay(w));
   normal_cursor (xpanel);
   /* printf ("selectCB nitems=%d\n", nitems); */
   /* for (m=0; m<nitems; m++) printf ("item2[%d]='%s'\n", m, item2[m]); */
/*
   for (m=nitems-1; m>=0; m--) XmListAddItem (list, XDEF(item2[m]));
*/
/* put things onto the bottom of the list so they're in proper order */
   for (m=0; m<nitems; m++) XmListAddItem (list, XDEF(item2[m]), 0);
   if (nitems) XtManageChild (dialog[i]);
   /* else	       alert ("selection command failed"); */
   XFlush (XtDisplay(w));
   XtSetSensitive (dismissPB, TRUE);
   XtSetSensitive (proceedPB, TRUE);
   XtFree(s);
}

/* -------------------------------------------------------------------- */

void
menuCB (w, client_data, call_data)
   Widget  w, client_data;
   XmPushButtonCallbackStruct *call_data;
{
    Widget menu;
    XmString sp;
    char *s;

    XtVaGetValues (w, XmNlabelString, &sp, NULL);
    XmStringGetLtoR (sp, XmSTRING_DEFAULT_CHARSET, &s);
    /* printf ("menuCB string='%s'\n", s); */
    XtVaSetValues (client_data, XmNvalue, s, NULL);
    XtFree (s);
}

/* -------------------------------------------------------------------- */

Widget make_menu_item (item_name, client_data, menu)
    char *item_name;
    Widget client_data, menu;
{
    Widget item;

    item = XmCreatePushButton (menu, item_name, NULL, 0);
    XtVaSetValues (item, XmNlabelString, XDEF(item_name), NULL);
    XtAddCallback (item, XmNactivateCallback, (XtCallbackProc) menuCB, client_data);
    XtManageChild (item);
    return (item);
}

/* -------------------------------------------------------------------- */

void main (argc, argv) /* build a panel to view/update explore env file */
   int argc;
   char **argv;
{
	extern char *optarg;
	extern int   optind, opterr;

	char *strsav(), *basename();

	Display     *display;
	ApplicationData data;
	XmString    prompt;
        XmFontList  font;
	Dimension   wid, hgt;
	Position    xp, yp;
	Screen      *scrn;
	int         right;
/*
	double pow();
*/

	char *getclass(), *classnm = getclass(&argc,argv);

        char label[41];
        char s80[80];
	char *cs, *col, *iniv, *minvs, *maxvs;
	char *oldvalue;

	int center=0, width=0, height=0, nrows=0, ncols=0;
	int i, m, n, c, fh, ph, gp, na, x, y, len;
	int init, nset, nitems, minv, maxv, ival, idec;
	double power;


/* initialize the Xt library */
	xpanel = XtAppInitialize (&context, classnm, opts, XtNumber(opts),
				  &argc, argv, app_defs, NULL, 0);

/* get application resources */
        XtGetApplicationResources (xpanel, &data, resources,
				   XtNumber(resources), NULL, 0);

	ac = 0;
        form2 = (Widget) XmCreateForm (xpanel, "panel", arg, ac);
	XtManageChild (form2);
        alert_init (xpanel);

	opterr = 0;

/* check command options */
	while ((c = getopt(argc,argv,"E:H:LBD")) != -1) {
	   switch(c) {
		case 'E': /* use alternate env file */
			envfile = strsav(optarg);
			break;
		case 'H': /* help command */
			helpcmd = strsav(optarg);
			break;
		case 'L': /* leave window open */
			leaveup++;
			break;
		case 'B': /* blanks not underscore */
			blanks++;
			break;
		case 'D': /* debug */
			debug++;
			break;
	   }
	}

/* make sure we have read/write perms for existing env file */
	if (access(envfile,F_OK) == 0) {
	   if (access(envfile,W_OK) == -1) {
		fprintf(stderr,"can't overwrite %s\n",envfile);
		exit(3);
	   }
	   if (access(envfile,R_OK) == -1) {
		fprintf(stderr,"can't read %s\n",envfile);
		exit(3);
	   }
	   if (gettags(envfile) < 0) exit(3);
	}

/* collect panel item field info */
	currow = 0;
	curcol = 2;
	if (getfields() < 1) exit (2);

/* add Dismiss button[i] */
        right = 50;
        if (helpcmd != NULL) right = 33;
	dismissPB = XmCreatePushButton (form2, "dismissPB", NULL, 0);
	XtVaSetValues (dismissPB,
	               XmNlabelString, XDEF (data.dismiss),
        	       XmNrightAttachment, XmATTACH_POSITION,
        	       XmNrightPosition, right,
	               XmNtopAttachment, XmATTACH_FORM, 
	               XmNleftAttachment, XmATTACH_FORM, NULL); 
	XtAddCallback (dismissPB, XmNactivateCallback, (XtCallbackProc) quitCB, 0);
	XtManageChild (dismissPB);
	helpPB = dismissPB;

/* intern delete atom and attach to dismissPB callback */
	delete_atom = XmInternAtom(XtDisplay(xpanel),"WM_DELETE_WINDOW",False);
	if (delete_atom == (Atom)None) {
		fprintf(stderr,"FATAL: %s can't intern WM_DELETE_WINDOW atom\n",
			basename(argv[0]));
		exit(1);
	}
	XmAddWMProtocols(xpanel,&delete_atom,1);
	XmAddWMProtocolCallback(xpanel,delete_atom,(XtCallbackProc) quitCB,dismissPB);

/* get character width and height */
	XtVaGetValues (dismissPB, XmNfontList, &font, NULL); 
	xmstr = XDEF ("W");
	width =  XmStringWidth  (font, xmstr);
	height = XmStringHeight (font, xmstr);
	XmStringFree (xmstr);

/* add Help button[i] */
        if (helpcmd != NULL) {
	    helpPB = XmCreatePushButton (form2, "helpPB", NULL, 0);
	    XtVaSetValues (helpPB,
	                   XmNlabelString, XDEF(data.help),
	                   XmNtopAttachment,   XmATTACH_FORM, 
        	           XmNrightAttachment, XmATTACH_POSITION,
        	           XmNrightPosition, 66,
	                   XmNleftAttachment, XmATTACH_WIDGET, 
	                   XmNleftWidget, dismissPB, NULL);
    	    XtAddCallback (helpPB, XmNactivateCallback, (XtCallbackProc) helpCB, helpcmd);
	    XtManageChild (helpPB);
        }

/* add Proceed button[i] */
	proceedPB = XmCreatePushButton (form2, "proceedPB", NULL, 0);
	XtVaSetValues (proceedPB,
	               XmNlabelString, XDEF(data.proceed),
	               XmNtopAttachment,   XmATTACH_FORM, 
	               XmNrightAttachment, XmATTACH_FORM, 
	               XmNleftAttachment, XmATTACH_WIDGET, 
	               XmNleftWidget, helpPB, NULL);
	XtAddCallback (proceedPB, XmNactivateCallback, (XtCallbackProc) proceedCB, 0);
	XtManageChild (proceedPB);

/* make scrolled window */
	for (i = 0; i < nfields; i++) {
	    if (flist[i]->f_row > nrows) nrows = flist[i]->f_row;
	    len = strlen(flist[i]->f_prompt);
	    len += flist[i]->f_col;
	    len += flist[i]->f_length;
	    if (len > ncols) ncols = len;
	}

	ac = 0;
        scrn = XtScreen (xpanel);
        wid = WidthOfScreen(scrn);
        hgt = HeightOfScreen(scrn);
  	if ((int)(nrows*height*2 > (int)hgt-90) || 
	   ((int)ncols*width > (int)wid-20)) {   
	    if ((int)nrows*height*2 > (int)hgt-90) 
		nrows = (int) hgt*0.85 / (height*2); 
	    if ((int)ncols*width > (int)wid-90) 
		ncols = (int) wid*0.85 / width; 
  	    XSET (arg[ac++], XmNwidth, ncols*width+60);   
  	    XSET (arg[ac++], XmNheight, nrows*height*2+20);     
	    XSET (arg[ac++], XmNscrollingPolicy, XmAUTOMATIC);  
  	}   
        scrollbar = (Widget) XmCreateScrolledWindow (form2, "scroll", arg, ac);
	XtVaSetValues (scrollbar,
	               XmNbottomAttachment, XmATTACH_FORM, 
	               XmNleftAttachment,   XmATTACH_FORM, 
	               XmNrightAttachment,  XmATTACH_FORM, 
	               XmNtopAttachment,    XmATTACH_FORM, 
	               XmNtopOffset, height*2, NULL); 
	XtManageChild (scrollbar);

/* make form */
        form = (Widget) XmCreateForm (scrollbar, "form", NULL, 0);
	XtManageChild (form);
	 
/* now we can add the data labels and fields to the panel */
	for (i = 0; i < nfields; i++) {
	   x = flist[i]->f_col * width;
	   y = flist[i]->f_row * height * 2 + 4;

	   len = strlen(flist[i]->f_prompt);
	   desc = (Widget) XmCreateLabel (form, "desc", NULL, 0);
	   XtVaSetValues (desc,
	                  XmNcolumns, (short)len, 
	                  XmNlabelString, XDEF(flist[i]->f_prompt),
	                  XmNleftAttachment, XmATTACH_FORM,
	                  XmNtopAttachment, XmATTACH_FORM,
	                  XmNleftOffset, x,
	                  XmNtopOffset, y,
	                  XmNshadowThickness, (short)0, NULL); 
	   XtManageChild (desc);

	   if (flist[i]->f_type == FTLABEL) continue;

       	   iniv = flist[i]->f_type == FTPWORD ? "" : flist[i]->f_iniv;

	   if (flist[i]->f_type == FTTOGGLE) {
        	  /* value[i] = XmCreateToggleButton (form, "value", NULL, 0); */
        	   value[i] = XmCreateToggleButton (form, flist[i]->f_name, NULL, 0);
        	   XtVaSetValues (value[i],XmNlabelString, XDEF(" "), NULL);
       	           cs = findval(flist[i]->f_tag);
       	           if (cs) {
       	               if (!strcmp(cs,flist[i]->f_on)) 
		           XtVaSetValues (value[i],XmNset,TRUE,NULL); 
		   } else {
		       if (!strcmp(iniv,flist[i]->f_on)) 
		          XtVaSetValues (value[i],XmNset,TRUE,NULL); 
		   }
	   } else if (flist[i]->f_type == FTSLIDER) {
		   idec = flist[i]->f_prec;
		   if (idec < 0) idec = 0;
		   if (idec > 9) idec = 0;
		   power = (double) idec;
		   power = pow(10.0,power); 
		   maxv = (int) atof(flist[i]->f_maxv)*power;
		   minv = (int) atof(flist[i]->f_minv)*power;
		   ival = minv;
       	           if (iniv) ival = (int) ((float) atof(iniv)*power);
        	   /* value[i] = XmCreateScale (form, "value", NULL, 0); */
        	   value[i] = XmCreateScale (form, flist[i]->f_name, NULL, 0);
        	   XtVaSetValues (value[i],
				  XmNminimum, minv,
				  XmNmaximum, maxv,
				  XmNdecimalPoints, idec,
				  XmNshowValue, TRUE,
				  XmNorientation, XmHORIZONTAL,
				  XmNprocessingDirection, XmMAX_ON_RIGHT,
				  XmNscaleWidth, width*flist[i]->f_length,
				  XmNscaleHeight, height,
				  XmNvalue, ival, NULL);
	   } else {
        	   len = flist[i]->f_length;
        	   if (len <= 0) len = 40;
       	           if (iniv == NULL) iniv = " ";
       	           if (!blanks && iniv[0] == '_' ) iniv = " ";
        	   /* value[i] = XmCreateText (form, "value", NULL, 0); */
        	   value[i] = XmCreateText (form, flist[i]->f_name, NULL, 0);
        	   XtVaSetValues (value[i],
        	                  XmNvalue, iniv,  
        	                  XmNuserData, flist[i],  
        	                  XmNcolumns, (short)len, NULL);
		   if (flist[i]->f_type == FTPWORD)
			XtAddCallback(value[i], XmNmodifyVerifyCallback,
				(XtCallbackProc) pwordCB, flist[i]);
	   }

           XtVaSetValues (value[i],
                         XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET, 
                         XmNtopWidget, desc, XmNtopOffset, -5, 
                         XmNleftAttachment, XmATTACH_WIDGET, 
                         XmNleftWidget, desc, NULL); 
    	   XtManageChild (value[i]);

/* build pick menu */
           if (flist[i]->f_pick) {
    	       XtUnmanageChild (value[i]);
	       XtVaGetValues (value[i], XmNvalue, &oldvalue, NULL);
	       menu = (Widget) XmCreatePulldownMenu (form,flist[i]->f_name,NULL,0);
	       optn = (Widget) XmCreateOptionMenu (form,flist[i]->f_name,NULL,0);
               XtVaSetValues (optn,
	                  XmNsubMenuId, menu, 
                          XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET, 
                          XmNtopWidget, desc, XmNtopOffset, -5, 
                          XmNleftAttachment, XmATTACH_WIDGET, 
                          XmNleftWidget, desc, XmNleftOffset, -10, NULL); 
	       n = 0;
	       nset = 1;
	       init = 0;
	       selct = strsav(flist[i]->f_pick);
	       sel[n++] = (char *)strtok(selct,":");
	       while (sel[n] = (char *)strtok(NULL,":")) if (n<MAXSEL) n++;

/* code to get the radio box working on Solaris - omitted on switch to X11R6 */
	       if (flist[i]->f_iniv)
		   for (m=1; m<n; m++)
		     if (!strcmp(flist[i]->f_iniv, ljust(sel[m]))) {
			char *temp;
			temp = sel[0];
			sel[0] = sel[m];
			sel[m] = temp;
			}
/* code to get the radio box working on Solaris */

	       for (m=0; m<n; m++) {
		   sel[m] = trim(ljust(sel[m]));
                   if (!flist[i]->f_iniv)
			flist[i]->f_iniv = strsav(sel[m]);
		   if (!init && !strcmp(flist[i]->f_iniv, sel[m]))
			init = m;
	           optnum[m] = make_menu_item (sel[m], value[i], menu);
		   if (!strcmp(sel[m],oldvalue)) {
		       XtVaSetValues (menu, XmNmenuHistory, optnum[m], NULL);
		       nset = 0;
		   }
	       }
	       setval(flist[i]->f_tag, flist[i]->f_iniv);
	       if (nset) {
		   setval(flist[i]->f_tag, sel[init]);
		   XtVaSetValues(value[i], XmNvalue, sel[init], NULL);
	       }
	       free(selct);
	       XtManageChild (optn);
	       goto LOOP;
	   }

/* build selection dialog */
           if (flist[i]->f_select || flist[i]->f_type == FTPATH) { 
               button[i] = XmCreatePushButton (form, "", NULL, 0);
	       XtVaSetValues (button[i],
       	                  XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET, 
       	                  XmNbottomWidget, value[i], XmNbottomOffset, 5, 
       	                  XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET, 
       	                  XmNtopWidget, value[i], XmNtopOffset, 5, 
       	                  XmNleftAttachment, XmATTACH_WIDGET, 
       	                  XmNleftWidget, value[i], NULL); 
	       XtManageChild (button[i]);

	       if (flist[i]->f_type == FTPATH) 
	           dialog[i] = (Widget) XmCreateFileSelectionDialog
			                (xpanel, "dialog", NULL, 0);
	       else 
	           dialog[i] = (Widget) XmCreateSelectionDialog
			                (xpanel, "dialog", NULL, 0);
	       sprintf (s80, "%s selection", flist[i]->f_prompt);
	       XtVaSetValues (dialog[i], XmNdialogTitle, XDEF(s80), NULL);
	       XtAddCallback (dialog[i], XmNokCallback, (XtCallbackProc) dialogCB, (XtPointer)i);
	       XtAddCallback (dialog[i], XmNcancelCallback, (XtCallbackProc) unmanageCB, NULL);
	       XtUnmanageChild (XmSelectionBoxGetChild (dialog[i],
	        		XmDIALOG_HELP_BUTTON));
	       if (flist[i]->f_type == FTPATH) 
	           XtAddCallback(button[i],XmNactivateCallback,(XtCallbackProc) manageCB,dialog[i]);
	       else {
	           XtAddCallback (button[i], XmNactivateCallback,
			(XtCallbackProc) selectCB, (XtPointer) i);
	           XtUnmanageChild (XmSelectionBoxGetChild (dialog[i],
	        		XmDIALOG_APPLY_BUTTON));
	       }
           } 

/* add comment field */
           if (! flist[i]->f_cmnt) continue;

	   len = strlen(flist[i]->f_cmnt);
	   desc = (Widget) XmCreateLabel (form, "desc", NULL, 0);
	   XtVaSetValues (desc,
       	                  XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET, 
       	                  XmNtopWidget, value[i], 
       	                  XmNtopOffset, 5, 
       	                  XmNleftAttachment, XmATTACH_WIDGET, 
       	                  XmNleftWidget, value[i], 
	                  XmNlabelString, XDEF(flist[i]->f_cmnt),
	                  XmNshadowThickness, (short)0, NULL); 
	   XtManageChild (desc);

LOOP:      i = i;
	}
/* end of add field loop */

	XtVaSetValues (xpanel, XmNmappedWhenManaged, FALSE, NULL);
	XtRealizeWidget (xpanel);
        if (data.iconfile) seticon (xpanel, data.iconfile);
	
	centermap (xpanel);
	XmProcessTraversal (value[0], XmTRAVERSE_CURRENT);

	XtAppMainLoop (context);

}
