/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>

#ifdef CRAY
#define MAXPATHLEN PATH_MAX
#include <sys/types.h> 
#endif

#include <sys/stat.h> 

static char path[MAXPATHLEN+1];

int
canexec (cmd) /* check for execute access on file */
    char *cmd;
{
	extern char *getenv(), *strchr();

	int len, uid, gid, val;
	char *colon, *sp, *pathptr;

	*path = '\0';

        val = 0;
	if ((uid = geteuid()) == -1) goto retn;
	if ((gid = getegid()) == -1) goto retn;

	if (*cmd=='/' || !(pathptr = getenv("PATH"))) pathptr = ":";

	for (; (colon=strchr(pathptr,':')); pathptr = colon + 1) {
		len = colon - pathptr;
		strncpy(path,pathptr,len);
		path[len] = '\0';
		if (len > 0) strcat(path,"/");
		strcat(path,cmd);
		if (sp = strchr(path,' ')) *sp = '\0';

		if (isexec(path,uid,gid)) {
		   val = 1;
		   goto retn;
		}
	}

retn:
	return (val);
}

static int isexec (path, uid, gid) /* check for execute access on path */
   char *path;
   int uid, gid;
{
	static struct stat sbuf;
	int xit, val;

        val = 0;
        xit = 0;
	errno = ENOENT;
	if (stat(path,&sbuf) == -1) goto retn;	

        xit = 1;
	errno = ENOEXEC;
	if (sbuf.st_size <= 0) goto retn;	
	if ((sbuf.st_mode & S_IFMT) != S_IFREG) goto retn;	

        xit = 2;
	errno = EACCES;

	if (sbuf.st_uid == uid) {
		if ((sbuf.st_mode & S_IEXEC) == S_IEXEC) val = 1;
                goto retn;	
	}

        xit = 3;
	if (sbuf.st_gid = gid) {
		if ((sbuf.st_mode & S_IXGRP) == S_IXGRP) val = 1;
                goto retn;	
	}

        xit = 4;
	if ((sbuf.st_mode & S_IXOTH) == S_IXOTH) val = 1;
                
retn:
     /* printf ("isexec<xit %d val %d path %s\n", xit, val, path); */
	return (val);

}
